/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.BigAggregator;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.OptimisationUtils;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

abstract class ModelEntity<ME extends ModelEntity<ME>>
implements Optimisation.Constraint,
Optimisation.Objective,
Comparable<ME> {
    private static final BigDecimal LARGEST = new BigDecimal(Double.toString(Double.MAX_VALUE), new MathContext(8, RoundingMode.DOWN));
    private static final BigDecimal SMALLEST = new BigDecimal(Double.toString(Double.MIN_NORMAL), new MathContext(8, RoundingMode.UP));
    private transient int myAdjustmentExponent = Integer.MIN_VALUE;
    private BigDecimal myContributionWeight = null;
    private BigDecimal myLowerLimit = null;
    private final String myName;
    private BigDecimal myUpperLimit = null;

    private ModelEntity() {
        this("");
    }

    protected ModelEntity(ME entityToCopy) {
        this.myName = ((ModelEntity)entityToCopy).getName();
        this.myContributionWeight = ((ModelEntity)entityToCopy).getContributionWeight();
        this.myLowerLimit = ((ModelEntity)entityToCopy).getLowerLimit();
        this.myUpperLimit = ((ModelEntity)entityToCopy).getUpperLimit();
    }

    protected ModelEntity(String name) {
        this.myName = name;
        Objects.requireNonNull(name);
    }

    @Override
    public final int compareTo(ME obj) {
        return this.myName.compareTo(((ModelEntity)obj).getName());
    }

    public final boolean equals(Object obj) {
        boolean retVal = false;
        if (obj instanceof ModelEntity && this.myName.equals(((ModelEntity)obj).getName())) {
            retVal = true;
        }
        return retVal;
    }

    public final double getAdjustedLowerLimit() {
        BigDecimal tmpLowerLimit = this.getLowerLimit(true);
        if (tmpLowerLimit != null) {
            return tmpLowerLimit.doubleValue();
        }
        return Double.NEGATIVE_INFINITY;
    }

    public final double getAdjustedUpperLimit() {
        BigDecimal tmpUpperLimit = this.getUpperLimit(true);
        if (tmpUpperLimit != null) {
            return tmpUpperLimit.doubleValue();
        }
        return Double.POSITIVE_INFINITY;
    }

    public final double getAdjustmentFactor() {
        return BigDecimal.ONE.movePointRight(this.getAdjustmentExponent()).doubleValue();
    }

    @Override
    public final BigDecimal getContributionWeight() {
        return this.myContributionWeight;
    }

    @Override
    public final BigDecimal getLowerLimit() {
        return this.getLowerLimit(false);
    }

    public final String getName() {
        return this.myName;
    }

    @Override
    public final BigDecimal getUpperLimit() {
        return this.getUpperLimit(false);
    }

    public final int hashCode() {
        return this.myName.hashCode();
    }

    @Override
    public final boolean isConstraint() {
        return this.isLowerLimitSet() || this.isUpperLimitSet();
    }

    public final boolean isContributionWeightSet() {
        return this.myContributionWeight != null;
    }

    @Override
    public final boolean isEqualityConstraint() {
        return this.isLowerLimitSet() && this.isUpperLimitSet() && this.myLowerLimit.compareTo(this.myUpperLimit) == 0;
    }

    @Override
    public final boolean isLowerConstraint() {
        return this.isLowerLimitSet() && !this.isEqualityConstraint();
    }

    public final boolean isLowerLimitSet() {
        return this.myLowerLimit != null;
    }

    @Override
    public final boolean isObjective() {
        return this.isContributionWeightSet() && this.myContributionWeight.signum() != 0;
    }

    @Override
    public final boolean isUpperConstraint() {
        return this.isUpperLimitSet() && !this.isEqualityConstraint();
    }

    public final boolean isUpperLimitSet() {
        return this.myUpperLimit != null;
    }

    public final ME level(Number level) {
        return ((ModelEntity)this.lower(level)).upper(level);
    }

    public final ME lower(Number lower) {
        this.myAdjustmentExponent = Integer.MIN_VALUE;
        this.myLowerLimit = null;
        if (lower != null) {
            if (lower instanceof BigDecimal) {
                this.myLowerLimit = (BigDecimal)lower;
            } else if (Double.isFinite(lower.doubleValue())) {
                BigDecimal tmpLimit = TypeUtils.toBigDecimal(lower);
                BigDecimal tmpMagnitude = tmpLimit.abs();
                if (tmpMagnitude.compareTo(LARGEST) >= 0) {
                    tmpLimit = null;
                } else if (tmpMagnitude.compareTo(SMALLEST) <= 0) {
                    tmpLimit = BigMath.ZERO;
                }
                this.myLowerLimit = tmpLimit;
            }
        }
        return (ME)this;
    }

    public final String toString() {
        StringBuilder retVal = new StringBuilder();
        this.appendToString(retVal);
        return retVal.toString();
    }

    public final ME upper(Number upper) {
        this.myAdjustmentExponent = Integer.MIN_VALUE;
        this.myUpperLimit = null;
        if (upper != null) {
            if (upper instanceof BigDecimal) {
                this.myUpperLimit = (BigDecimal)upper;
            } else if (Double.isFinite(upper.doubleValue())) {
                BigDecimal tmpLimit = TypeUtils.toBigDecimal(upper);
                BigDecimal tmpMagnitude = tmpLimit.abs();
                if (tmpMagnitude.compareTo(LARGEST) >= 0) {
                    tmpLimit = null;
                } else if (tmpMagnitude.compareTo(SMALLEST) <= 0) {
                    tmpLimit = BigMath.ZERO;
                }
                this.myUpperLimit = tmpLimit;
            }
        }
        return (ME)this;
    }

    public final ME weight(Number weight) {
        this.myContributionWeight = null;
        if (weight != null) {
            BigDecimal tmpWeight = null;
            if (weight instanceof BigDecimal) {
                tmpWeight = (BigDecimal)weight;
            } else if (Double.isFinite(weight.doubleValue())) {
                tmpWeight = TypeUtils.toBigDecimal(weight);
            }
            if (tmpWeight != null && tmpWeight.signum() != 0) {
                this.myContributionWeight = tmpWeight;
            }
        }
        return (ME)this;
    }

    protected void appendLeftPart(StringBuilder builder) {
        if (this.isLowerConstraint() || this.isEqualityConstraint()) {
            builder.append(OptimisationUtils.DISPLAY.enforce(this.getLowerLimit()).toPlainString());
            builder.append(" <= ");
        }
    }

    protected void appendMiddlePart(StringBuilder builder) {
        builder.append(this.getName());
        if (this.isObjective()) {
            builder.append(" (");
            builder.append(OptimisationUtils.DISPLAY.enforce(this.getContributionWeight()).toPlainString());
            builder.append(")");
        }
    }

    protected void appendRightPart(StringBuilder builder) {
        if (this.isUpperConstraint() || this.isEqualityConstraint()) {
            builder.append(" <= ");
            builder.append(OptimisationUtils.DISPLAY.enforce(this.getUpperLimit()).toPlainString());
        }
    }

    protected void destroy() {
        this.myContributionWeight = null;
        this.myLowerLimit = null;
        this.myUpperLimit = null;
    }

    protected final int getAdjustmentExponent() {
        if (this.myAdjustmentExponent == Integer.MIN_VALUE) {
            BigAggregator tmpSet = BigAggregator.getSet();
            AggregatorFunction<BigDecimal> tmpLargest = ((AggregatorSet)tmpSet).largest();
            AggregatorFunction<BigDecimal> tmpSmallest = ((AggregatorSet)tmpSet).smallest();
            this.visitAllParameters(tmpLargest, tmpSmallest);
            this.myAdjustmentExponent = OptimisationUtils.getAdjustmentExponent(tmpLargest.doubleValue(), tmpSmallest.doubleValue());
        }
        return this.myAdjustmentExponent;
    }

    protected boolean validate(BasicLogger.Printer appender) {
        boolean retVal = true;
        if (this.myLowerLimit != null && this.myUpperLimit != null && (this.myLowerLimit.compareTo(this.myUpperLimit) == 1 || this.myUpperLimit.compareTo(this.myLowerLimit) == -1)) {
            if (appender != null) {
                appender.println(this.toString() + " The lower limit (if it exists) must be smaller than or equal to the upper limit (if it exists)!");
            }
            retVal = false;
        }
        if (this.myContributionWeight != null && this.myContributionWeight.signum() == 0) {
            if (appender != null) {
                appender.println(this.toString() + " The contribution weight (if it exists) should not be zero!");
            }
            retVal = false;
        }
        return retVal;
    }

    protected boolean validate(BigDecimal value, NumberContext context, BasicLogger.Printer appender) {
        boolean retVal = true;
        BigDecimal tmpLimit = null;
        tmpLimit = this.getLowerLimit();
        if (tmpLimit != null && value.subtract(tmpLimit).signum() == -1 && context.isDifferent(tmpLimit.doubleValue(), value.doubleValue())) {
            if (appender != null) {
                appender.println(value + " ! " + this.toString());
            }
            retVal = false;
        }
        if ((tmpLimit = this.getUpperLimit()) != null && value.subtract(tmpLimit).signum() == 1 && context.isDifferent(tmpLimit.doubleValue(), value.doubleValue())) {
            if (appender != null) {
                appender.println(value + " ! " + this.toString());
            }
            retVal = false;
        }
        return retVal;
    }

    final void appendToString(StringBuilder builder) {
        this.appendLeftPart(builder);
        this.appendMiddlePart(builder);
        this.appendRightPart(builder);
    }

    final BigDecimal getLowerLimit(boolean adjusted) {
        if (adjusted && this.myLowerLimit != null) {
            int tmpAdjustmentExponent = this.getAdjustmentExponent();
            if (tmpAdjustmentExponent != 0) {
                return this.myLowerLimit.movePointRight(tmpAdjustmentExponent);
            }
            return this.myLowerLimit;
        }
        return this.myLowerLimit;
    }

    final BigDecimal getUpperLimit(boolean adjusted) {
        if (adjusted && this.myUpperLimit != null) {
            int tmpAdjustmentExponent = this.getAdjustmentExponent();
            if (tmpAdjustmentExponent != 0) {
                return this.myUpperLimit.movePointRight(tmpAdjustmentExponent);
            }
            return this.myUpperLimit;
        }
        return this.myUpperLimit;
    }

    boolean isInfeasible() {
        return this.myLowerLimit != null && this.myUpperLimit != null && this.myLowerLimit.compareTo(this.myUpperLimit) > 0;
    }

    void visitAllParameters(VoidFunction<BigDecimal> largest, VoidFunction<BigDecimal> smallest) {
        largest.invoke(BigMath.ONE);
        smallest.invoke(BigMath.ONE);
        if (this.myLowerLimit != null) {
            largest.invoke(this.myLowerLimit);
            smallest.invoke(this.myLowerLimit);
        }
        if (this.myUpperLimit != null) {
            largest.invoke(this.myUpperLimit);
            smallest.invoke(this.myUpperLimit);
        }
    }
}

