/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.transformation;

import java.math.BigDecimal;
import org.ojalgo.ProgrammingError;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.function.ComplexFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;

public abstract class Rotation<N extends Number> {
    public final int high;
    public final int low;

    public static Big makeBig(int aLowerIndex, int aHigherIndex, BigDecimal anAngle) {
        return new Big(aLowerIndex, aHigherIndex, BigFunction.COS.invoke(anAngle), BigFunction.SIN.invoke(anAngle));
    }

    public static Complex makeComplex(int aLowerIndex, int aHigherIndex, ComplexNumber anAngle) {
        return new Complex(aLowerIndex, aHigherIndex, ComplexFunction.COS.invoke(anAngle), ComplexFunction.SIN.invoke(anAngle));
    }

    public static Primitive makePrimitive(int aLowerIndex, int aHigherIndex, double anAngle) {
        return new Primitive(aLowerIndex, aHigherIndex, PrimitiveFunction.COS.invoke(anAngle), PrimitiveFunction.SIN.invoke(anAngle));
    }

    static Rotation<BigDecimal>[] rotationsB(PhysicalStore<BigDecimal> matrix, int low, int high, Rotation<BigDecimal>[] results) {
        BigDecimal t;
        BigDecimal sg;
        BigDecimal cg;
        BigDecimal a00 = (BigDecimal)matrix.get(low, low);
        BigDecimal a01 = (BigDecimal)matrix.get(low, high);
        BigDecimal a10 = (BigDecimal)matrix.get(high, low);
        BigDecimal a11 = (BigDecimal)matrix.get(high, high);
        BigDecimal x = a00.add(a11);
        BigDecimal y = a10.subtract(a01);
        if (y.signum() == 0) {
            cg = BigFunction.SIGNUM.invoke(x);
            sg = BigMath.ZERO;
        } else if (x.signum() == 0) {
            sg = BigFunction.SIGNUM.invoke(y);
            cg = BigMath.ZERO;
        } else if (y.abs().compareTo(x.abs()) == 1) {
            t = BigFunction.DIVIDE.invoke(x, y);
            sg = BigFunction.DIVIDE.invoke(BigFunction.SIGNUM.invoke(y), BigFunction.SQRT1PX2.invoke(t));
            cg = sg.multiply(t);
        } else {
            t = BigFunction.DIVIDE.invoke(y, x);
            cg = BigFunction.DIVIDE.invoke(BigFunction.SIGNUM.invoke(x), BigFunction.SQRT1PX2.invoke(t));
            sg = cg.multiply(t);
        }
        BigDecimal b00 = cg.multiply(a00).add(sg.multiply(a10));
        BigDecimal b11 = cg.multiply(a11).subtract(sg.multiply(a01));
        BigDecimal b2 = cg.multiply(a01.add(a10)).add(sg.multiply(a11.subtract(a00)));
        t = BigFunction.DIVIDE.invoke(b11.subtract(b00), b2);
        t = BigFunction.DIVIDE.invoke(BigFunction.SIGNUM.invoke(t), BigFunction.SQRT1PX2.invoke(t).add(t.abs()));
        BigDecimal cj = BigFunction.DIVIDE.invoke(BigMath.ONE, BigFunction.SQRT1PX2.invoke(t));
        BigDecimal sj = cj.multiply(t);
        results[1] = new Big(low, high, cj, sj);
        results[0] = new Big(low, high, cj.multiply(cg).add(sj.multiply(sg)), cj.multiply(sg).subtract(sj.multiply(cg)));
        return results;
    }

    static Rotation<ComplexNumber>[] rotationsC(PhysicalStore<ComplexNumber> matrix, int low, int high, Rotation<ComplexNumber>[] results) {
        ComplexNumber t;
        ComplexNumber sg;
        ComplexNumber cg;
        ComplexNumber a00 = (ComplexNumber)matrix.get(low, low);
        ComplexNumber a01 = (ComplexNumber)matrix.get(low, high);
        ComplexNumber a10 = (ComplexNumber)matrix.get(high, low);
        ComplexNumber a11 = (ComplexNumber)matrix.get(high, high);
        ComplexNumber x = a00.add(a11);
        ComplexNumber y = a10.subtract(a01);
        if (ComplexNumber.isSmall(PrimitiveMath.ONE, y)) {
            cg = x.signum();
            sg = ComplexNumber.ZERO;
        } else if (ComplexNumber.isSmall(PrimitiveMath.ONE, x)) {
            sg = y.signum();
            cg = ComplexNumber.ZERO;
        } else if (y.compareTo(x) == 1) {
            t = x.divide(y);
            sg = y.signum().divide(ComplexFunction.SQRT1PX2.invoke(t));
            cg = sg.multiply(t);
        } else {
            t = y.divide(x);
            cg = x.signum().divide(ComplexFunction.SQRT1PX2.invoke(t));
            sg = cg.multiply(t);
        }
        ComplexNumber b00 = cg.multiply(a00).add(sg.multiply(a10));
        ComplexNumber b11 = cg.multiply(a11).subtract(sg.multiply(a01));
        ComplexNumber b2 = cg.multiply(a01.add(a10)).add(sg.multiply(a11.subtract(a00)));
        t = b11.subtract(b00).divide(b2);
        t = t.signum().divide(ComplexFunction.SQRT1PX2.invoke(t).add(t.norm()));
        ComplexNumber cj = ComplexFunction.SQRT1PX2.invoke(t).invert();
        ComplexNumber sj = cj.multiply(t);
        results[1] = new Complex(low, high, cj, sj);
        results[0] = new Complex(low, high, cj.multiply(cg).add(sj.multiply(sg)), cj.multiply(sg).subtract(sj.multiply(cg)));
        return results;
    }

    static Rotation<Double>[] rotationsP(PhysicalStore<Double> matrix, int low, int high, Rotation<Double>[] results) {
        double t;
        double sg;
        double cg;
        double a00 = matrix.doubleValue(low, low);
        double a01 = matrix.doubleValue(low, high);
        double a10 = matrix.doubleValue(high, low);
        double a11 = matrix.doubleValue(high, high);
        double x = a00 + a11;
        double y = a10 - a01;
        if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, y)) {
            cg = PrimitiveFunction.SIGNUM.invoke(x);
            sg = PrimitiveMath.ZERO;
        } else if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, x)) {
            sg = PrimitiveFunction.SIGNUM.invoke(y);
            cg = PrimitiveMath.ZERO;
        } else if (PrimitiveFunction.ABS.invoke(y) > PrimitiveFunction.ABS.invoke(x)) {
            t = x / y;
            sg = PrimitiveFunction.SIGNUM.invoke(y) / PrimitiveFunction.SQRT1PX2.invoke(t);
            cg = sg * t;
        } else {
            t = y / x;
            cg = PrimitiveFunction.SIGNUM.invoke(x) / PrimitiveFunction.SQRT1PX2.invoke(t);
            sg = cg * t;
        }
        double b00 = cg * a00 + sg * a10;
        double b11 = cg * a11 - sg * a01;
        double b2 = cg * (a01 + a10) + sg * (a11 - a00);
        t = (b11 - b00) / b2;
        t = PrimitiveFunction.SIGNUM.invoke(t) / (PrimitiveFunction.SQRT1PX2.invoke(t) + PrimitiveFunction.ABS.invoke(t));
        double cj = PrimitiveMath.ONE / PrimitiveFunction.SQRT1PX2.invoke(t);
        double sj = cj * t;
        results[1] = new Primitive(low, high, cj, sj);
        results[0] = new Primitive(low, high, cj * cg + sj * sg, cj * sg - sj * cg);
        return results;
    }

    private Rotation() {
        this(0, 0);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected Rotation(int aLowerIndex, int aHigherIndex) {
        this.low = aLowerIndex;
        this.high = aHigherIndex;
    }

    public abstract double doubleCosineValue();

    public abstract double doubleSineValue();

    public abstract N getCosine();

    public abstract N getSine();

    public abstract Rotation<N> invert();

    public String toString() {
        return "low=" + this.low + ", high=" + this.high + ", cos=" + this.getCosine() + ", sin=" + this.getSine();
    }

    public static final class Primitive
    extends Rotation<Double> {
        public final double cos;
        public final double sin;

        public Primitive(int index) {
            this(index, index, Double.NaN, Double.NaN);
        }

        public Primitive(int aLowerIndex, int aHigherIndex) {
            this(aLowerIndex, aHigherIndex, Double.NaN, Double.NaN);
        }

        public Primitive(int aLowerIndex, int aHigherIndex, double aCosine, double aSine) {
            super(aLowerIndex, aHigherIndex);
            this.cos = aCosine;
            this.sin = aSine;
        }

        public Primitive(Rotation<Double> aRotation) {
            super(aRotation.low, aRotation.high);
            this.cos = aRotation.getCosine() != null && !Double.isNaN(aRotation.doubleCosineValue()) ? aRotation.doubleCosineValue() : Double.NaN;
            this.sin = aRotation.getSine() != null && !Double.isNaN(aRotation.doubleSineValue()) ? aRotation.doubleSineValue() : Double.NaN;
        }

        @Override
        public double doubleCosineValue() {
            return this.cos;
        }

        @Override
        public double doubleSineValue() {
            return this.sin;
        }

        @Override
        public Double getCosine() {
            return this.cos;
        }

        @Override
        public Double getSine() {
            return this.sin;
        }

        public Primitive invert() {
            return new Primitive(this.high, this.low, this.cos, this.sin);
        }
    }

    public static final class Complex
    extends Rotation<ComplexNumber> {
        public final ComplexNumber cos;
        public final ComplexNumber sin;

        public Complex(int index) {
            this(index, index, null, null);
        }

        public Complex(int aLowerIndex, int aHigherIndex) {
            this(aLowerIndex, aHigherIndex, null, null);
        }

        public Complex(int aLowerIndex, int aHigherIndex, ComplexNumber aCosine, ComplexNumber aSine) {
            super(aLowerIndex, aHigherIndex);
            this.cos = aCosine;
            this.sin = aSine;
        }

        public Complex(Rotation<ComplexNumber> aRotation) {
            super(aRotation.low, aRotation.high);
            this.cos = aRotation.getCosine();
            this.sin = aRotation.getSine();
        }

        @Override
        public double doubleCosineValue() {
            return this.cos.doubleValue();
        }

        @Override
        public double doubleSineValue() {
            return this.sin.doubleValue();
        }

        @Override
        public ComplexNumber getCosine() {
            return this.cos;
        }

        @Override
        public ComplexNumber getSine() {
            return this.sin;
        }

        public Complex invert() {
            return new Complex(this.high, this.low, this.cos, this.sin);
        }
    }

    public static final class Big
    extends Rotation<BigDecimal> {
        public final BigDecimal cos;
        public final BigDecimal sin;

        public Big(int index) {
            this(index, index, null, null);
        }

        public Big(int aLowerIndex, int aHigherIndex) {
            this(aLowerIndex, aHigherIndex, null, null);
        }

        public Big(int aLowerIndex, int aHigherIndex, BigDecimal aCosine, BigDecimal aSine) {
            super(aLowerIndex, aHigherIndex);
            this.cos = aCosine;
            this.sin = aSine;
        }

        public Big(Rotation<BigDecimal> aRotation) {
            super(aRotation.low, aRotation.high);
            this.cos = aRotation.getCosine();
            this.sin = aRotation.getSine();
        }

        @Override
        public double doubleCosineValue() {
            return this.cos.doubleValue();
        }

        @Override
        public double doubleSineValue() {
            return this.sin.doubleValue();
        }

        @Override
        public BigDecimal getCosine() {
            return this.cos;
        }

        @Override
        public BigDecimal getSine() {
            return this.sin;
        }

        public Big invert() {
            return new Big(this.high, this.low, this.cos, this.sin);
        }
    }
}

