/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task.iterative;

import java.util.List;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.task.TaskException;
import org.ojalgo.matrix.task.iterative.Equation;
import org.ojalgo.matrix.task.iterative.IterativeSolverTask;
import org.ojalgo.matrix.task.iterative.KrylovSubspaceSolver;
import org.ojalgo.type.context.NumberContext;

public final class ConjugateGradientSolver
extends KrylovSubspaceSolver
implements IterativeSolverTask.SparseDelegate {
    private transient PrimitiveDenseStore myDirection = null;
    private transient PrimitiveDenseStore myPreconditioned = null;
    private transient PrimitiveDenseStore myResidual = null;
    private transient PrimitiveDenseStore myVector = null;

    @Override
    public double resolve(List<Equation> equations, PhysicalStore<Double> solution) {
        int tmpCountRows = equations.size();
        double tmpNormErr = Double.POSITIVE_INFINITY;
        double tmpNormRHS = PrimitiveMath.ONE;
        PrimitiveDenseStore tmpResidual = this.residual(solution);
        PrimitiveDenseStore tmpDirection = this.direction(solution);
        PrimitiveDenseStore tmpPreconditioned = this.preconditioned(solution);
        PrimitiveDenseStore tmpVector = this.vector(solution);
        double zr0 = 1.0;
        double zr1 = 1.0;
        double pAp0 = 0.0;
        for (int r = 0; r < tmpCountRows; ++r) {
            Equation tmpRow = equations.get(r);
            double tmpVal = tmpRow.getRHS();
            tmpNormRHS = PrimitiveFunction.HYPOT.invoke(tmpNormRHS, tmpVal);
            tmpResidual.set((long)tmpRow.index, tmpVal -= tmpRow.dot(solution));
            tmpPreconditioned.set((long)tmpRow.index, tmpVal / tmpRow.getPivot());
        }
        tmpDirection.fillMatching(tmpPreconditioned);
        int tmpIterations = 0;
        int tmpLimit = this.getIterationsLimit();
        NumberContext tmpCntxt = this.getAccuracyContext();
        zr1 = tmpPreconditioned.dot(tmpResidual);
        do {
            Equation tmpRow;
            zr0 = zr1;
            for (int i = 0; i < tmpCountRows; ++i) {
                tmpRow = equations.get(i);
                double tmpVal = tmpRow.dot(tmpDirection);
                tmpVector.set((long)tmpRow.index, tmpVal);
            }
            pAp0 = tmpDirection.dot(tmpVector);
            double tmpStepLength = zr0 / pAp0;
            if (!Double.isNaN(tmpStepLength)) {
                tmpDirection.axpy(tmpStepLength, solution);
                tmpVector.axpy(-tmpStepLength, tmpResidual);
            }
            tmpNormErr = PrimitiveMath.ZERO;
            for (int r = 0; r < tmpCountRows; ++r) {
                tmpRow = equations.get(r);
                double tmpValue = tmpResidual.doubleValue((long)tmpRow.index);
                tmpNormErr = PrimitiveFunction.HYPOT.invoke(tmpNormErr, tmpValue);
                tmpPreconditioned.set((long)tmpRow.index, tmpValue / tmpRow.getPivot());
            }
            zr1 = tmpPreconditioned.dot(tmpResidual);
            double tmpGradientCorrectionFactor = zr1 / zr0;
            tmpDirection.modifyAll((UnaryFunction<Double>)PrimitiveFunction.MULTIPLY.second(tmpGradientCorrectionFactor));
            tmpDirection.modifyMatching(PrimitiveFunction.ADD, tmpPreconditioned);
            ++tmpIterations;
            if (!this.isDebugPrinterSet()) continue;
            this.debug(tmpIterations, solution);
        } while (tmpIterations < tmpLimit && !Double.isNaN(tmpNormErr) && !tmpCntxt.isSmall(tmpNormRHS, tmpNormErr));
        return tmpNormErr / tmpNormRHS;
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws TaskException {
        List<Equation> tmpRows = IterativeSolverTask.toListOfRows(body, rhs);
        this.resolve(tmpRows, preallocated);
        return preallocated;
    }

    private PrimitiveDenseStore direction(Structure1D structure) {
        if (this.myDirection == null || this.myDirection.count() != structure.count()) {
            this.myDirection = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(structure.count(), 1L);
        } else {
            this.myDirection.fillAll(PrimitiveMath.ZERO);
        }
        return this.myDirection;
    }

    private PrimitiveDenseStore preconditioned(Structure1D structure) {
        if (this.myPreconditioned == null || this.myPreconditioned.count() != structure.count()) {
            this.myPreconditioned = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(structure.count(), 1L);
        } else {
            this.myPreconditioned.fillAll(PrimitiveMath.ZERO);
        }
        return this.myPreconditioned;
    }

    private PrimitiveDenseStore residual(Structure1D structure) {
        if (this.myResidual == null || this.myResidual.count() != structure.count()) {
            this.myResidual = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(structure.count(), 1L);
        } else {
            this.myResidual.fillAll(PrimitiveMath.ZERO);
        }
        return this.myResidual;
    }

    private PrimitiveDenseStore vector(Structure1D structure) {
        if (this.myVector == null || this.myVector.count() != structure.count()) {
            this.myVector = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(structure.count(), 1L);
        } else {
            this.myVector.fillAll(PrimitiveMath.ZERO);
        }
        return this.myVector;
    }
}

