/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.scalar.PrimitiveScalar;

public abstract class FunctionUtils {
    public static <N extends Number> boolean isZeroModified(UnaryFunction<N> function) {
        return !PrimitiveScalar.isSmall(PrimitiveMath.ONE, function.invoke(PrimitiveMath.ZERO));
    }

    public static double max(double ... values) {
        double retVal = values[0];
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] > retVal ? values[i] : retVal;
        }
        return retVal;
    }

    public static double max(double a, double b) {
        return Math.max(a, b);
    }

    public static double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    public static double max(double a, double b, double c, double d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    public static int max(int ... values) {
        int retVal = values[0];
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] > retVal ? values[i] : retVal;
        }
        return retVal;
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static int max(int a, int b, int c) {
        return Math.max(Math.max(a, b), c);
    }

    public static int max(int a, int b, int c, int d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    public static long max(long ... values) {
        long retVal = values[0];
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] > retVal ? values[i] : retVal;
        }
        return retVal;
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    public static long max(long a, long b, long c) {
        return Math.max(Math.max(a, b), c);
    }

    public static long max(long a, long b, long c, long d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    public static double min(double ... values) {
        double retVal = values[0];
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] < retVal ? values[i] : retVal;
        }
        return retVal;
    }

    public static double min(double a, double b) {
        return Math.min(a, b);
    }

    public static double min(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }

    public static double min(double a, double b, double c, double d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    public static int min(int ... values) {
        int retVal = values[0];
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] < retVal ? values[i] : retVal;
        }
        return retVal;
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public static int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static int min(int a, int b, int c, int d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    public static long min(long ... values) {
        long retVal = values[0];
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] < retVal ? values[i] : retVal;
        }
        return retVal;
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    public static long min(long a, long b, long c) {
        return Math.min(Math.min(a, b), c);
    }

    public static long min(long a, long b, long c, long d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    public static double norm(double ... values) {
        double retVal = Math.abs(values[0]);
        int i = values.length;
        while (i-- != 1) {
            retVal = values[i] > retVal ? Math.abs(values[i]) : retVal;
        }
        return retVal;
    }

    public static double norm(double a, double b) {
        return Math.max(Math.abs(a), Math.abs(b));
    }

    public static double norm(double a, double b, double c) {
        return Math.max(Math.max(Math.abs(a), Math.abs(b)), Math.abs(c));
    }

    public static double norm(double a, double b, double c, double d) {
        return Math.max(Math.max(Math.abs(a), Math.abs(b)), Math.max(Math.abs(c), Math.abs(d)));
    }

    private FunctionUtils() {
    }
}

