/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import java.util.Comparator;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.ScalarArray;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.function.QuaternionFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.QuaternionAggregator;
import org.ojalgo.machine.MemoryEstimator;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.Scalar;

public class QuaternionArray
extends ScalarArray<Quaternion> {
    public static final DenseArray.Factory<Quaternion> FACTORY = new DenseArray.Factory<Quaternion>(){

        @Override
        public AggregatorSet<Quaternion> aggregator() {
            return QuaternionAggregator.getSet();
        }

        @Override
        public FunctionSet<Quaternion> function() {
            return QuaternionFunction.getSet();
        }

        @Override
        public Scalar.Factory<Quaternion> scalar() {
            return Quaternion.FACTORY;
        }

        @Override
        long getElementSize() {
            return ELEMENT_SIZE;
        }

        @Override
        PlainArray<Quaternion> make(long size) {
            return QuaternionArray.make((int)size);
        }
    };
    static final long ELEMENT_SIZE = MemoryEstimator.estimateObject(Quaternion.class);

    public static final QuaternionArray make(int size) {
        return new QuaternionArray(size);
    }

    public static final QuaternionArray wrap(Quaternion[] data) {
        return new QuaternionArray(data);
    }

    protected QuaternionArray(int size) {
        super((Number[])new Quaternion[size]);
        this.fill(0, size, 1, Quaternion.ZERO);
    }

    protected QuaternionArray(Quaternion[] data) {
        super((Number[])data);
    }

    @Override
    public boolean equals(Object anObj) {
        if (anObj instanceof QuaternionArray) {
            return Arrays.equals(this.data, ((QuaternionArray)anObj).data);
        }
        return super.equals(anObj);
    }

    @Override
    public final void fillMatching(Access1D<?> values) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), values.count());
        for (int i = 0; i < tmpLimit; ++i) {
            ((Quaternion[])this.data)[i] = Quaternion.valueOf(values.get(i));
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public final void sortAscending() {
        Arrays.parallelSort((Comparable[])((Comparable[])this.data));
    }

    @Override
    public void sortDescending() {
        Arrays.parallelSort(this.data, Comparator.reverseOrder());
    }

    @Override
    protected final void add(int index, double addend) {
        this.fillOne(index, ((Quaternion)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected final void add(int index, Number addend) {
        this.fillOne(index, ((Quaternion)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected boolean isAbsolute(int index) {
        return Quaternion.isAbsolute(((Quaternion[])this.data)[index]);
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return Quaternion.isSmall(comparedTo, ((Quaternion[])this.data)[index]);
    }

    @Override
    final Quaternion valueOf(double value) {
        return Quaternion.valueOf(value);
    }

    @Override
    final Quaternion valueOf(Number number) {
        return Quaternion.valueOf(number);
    }
}

