/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import org.ojalgo.access.Structure1D;

public interface Structure2D
extends Structure1D {
    public static int column(int index, int structure) {
        return index / structure;
    }

    public static int column(int index, int[] structure) {
        return Structure2D.column(index, structure[0]);
    }

    public static int column(long index, int structure) {
        return (int)(index / (long)structure);
    }

    public static long column(long index, long structure) {
        return index / structure;
    }

    public static long column(long index, long[] structure) {
        return Structure2D.column(index, structure[0]);
    }

    public static int index(int structure, int row, int column) {
        return row + column * structure;
    }

    public static long index(long structure, long row, long column) {
        return row + column * structure;
    }

    public static void loopMatching(Structure2D structureA, Structure2D structureB, RowColumnCallback callback) {
        long tmpCountRows = Math.min(structureA.countRows(), structureB.countRows());
        long tmpCountColumns = Math.min(structureA.countColumns(), structureB.countColumns());
        for (long j = 0L; j < tmpCountColumns; ++j) {
            for (long i = 0L; i < tmpCountRows; ++i) {
                callback.call(i, j);
            }
        }
    }

    public static int row(int index, int structure) {
        return index % structure;
    }

    public static int row(int index, int[] structure) {
        return Structure2D.row(index, structure[0]);
    }

    public static int row(long index, int structure) {
        return (int)(index % (long)structure);
    }

    public static long row(long index, long structure) {
        return index % structure;
    }

    public static long row(long index, long[] structure) {
        return Structure2D.row(index, structure[0]);
    }

    @Override
    default public long count() {
        return this.countRows() * this.countColumns();
    }

    public long countColumns();

    public long countRows();

    default public boolean isEmpty() {
        return this.countRows() <= 0L || this.countColumns() <= 0L;
    }

    default public boolean isFat() {
        long tmpCountRows = this.countRows();
        return tmpCountRows > 0L && tmpCountRows < this.countColumns();
    }

    default public boolean isScalar() {
        return this.countRows() == 1L && this.countColumns() == 1L;
    }

    default public boolean isSquare() {
        long tmpCountRows = this.countRows();
        return tmpCountRows > 0L && tmpCountRows == this.countColumns();
    }

    default public boolean isTall() {
        long tmpCountColumns = this.countColumns();
        return tmpCountColumns > 0L && this.countRows() > tmpCountColumns;
    }

    default public boolean isVector() {
        return this.countColumns() == 1L || this.countRows() == 1L;
    }

    default public void loopAll(RowColumnCallback callback) {
        long tmpCountRows = this.countRows();
        long tmpCountColumns = this.countColumns();
        for (long j = 0L; j < tmpCountColumns; ++j) {
            for (long i = 0L; i < tmpCountRows; ++i) {
                callback.call(i, j);
            }
        }
    }

    default public void loopColumn(long row, long col, RowColumnCallback callback) {
        long tmpCountRows = this.countRows();
        for (long i = row; i < tmpCountRows; ++i) {
            callback.call(i, col);
        }
    }

    default public void loopColumn(long col, RowColumnCallback callback) {
        this.loopColumn(0L, col, callback);
    }

    default public void loopDiagonal(long row, long col, RowColumnCallback callback) {
        long tmpLimit = Math.min(this.countRows() - row, this.countColumns() - col);
        for (long ij = 0L; ij < tmpLimit; ++ij) {
            callback.call(row + ij, col + ij);
        }
    }

    default public void loopRow(long row, long col, RowColumnCallback callback) {
        long tmpCountColumns = this.countColumns();
        for (long j = col; j < tmpCountColumns; ++j) {
            callback.call(row, j);
        }
    }

    default public void loopRow(long row, RowColumnCallback callback) {
        this.loopRow(row, 0L, callback);
    }

    @FunctionalInterface
    public static interface RowColumnCallback {
        public void call(long var1, long var3);
    }
}

