/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.routing.Range;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import com.microsoft.azure.cosmosdb.rx.internal.query.DocumentProducer;
import com.microsoft.azure.cosmosdb.rx.internal.query.DocumentQueryExecutionContextBase;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryClient;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryExecutionComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func3;

public abstract class ParallelDocumentQueryExecutionContextBase<T extends Resource>
extends DocumentQueryExecutionContextBase<T>
implements IDocumentQueryExecutionComponent<T> {
    protected final List<DocumentProducer<T>> documentProducers = new ArrayList<DocumentProducer<T>>();
    protected final List<PartitionKeyRange> partitionKeyRanges;
    protected final SqlQuerySpec querySpec;
    protected int pageSize;
    protected int top = -1;

    protected ParallelDocumentQueryExecutionContextBase(IDocumentQueryClient client, List<PartitionKeyRange> partitionKeyRanges, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, String rewrittenQuery, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        super(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, getLazyFeedResponse, correlatedActivityId);
        this.partitionKeyRanges = partitionKeyRanges;
        this.querySpec = !Strings.isNullOrEmpty((String)rewrittenQuery) ? new SqlQuerySpec(rewrittenQuery, this.query.getParameters()) : this.query;
    }

    protected void initialize(String collectionRid, Map<PartitionKeyRange, String> partitionKeyRangeToContinuationTokenMap, int initialPageSize, SqlQuerySpec querySpecForInit) {
        this.pageSize = initialPageSize;
        Map<String, String> commonRequestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(null, null));
        for (PartitionKeyRange targetRange : partitionKeyRangeToContinuationTokenMap.keySet()) {
            Func3 createRequestFunc = (partitionKeyRange, continuationToken, pageSize) -> {
                HashMap<String, String> headers = new HashMap<String, String>(commonRequestHeaders);
                headers.put("x-ms-continuation", (String)continuationToken);
                headers.put("x-ms-max-item-count", Strings.toString((int)pageSize));
                return this.createDocumentServiceRequest((Map<String, String>)headers, querySpecForInit, (PartitionKeyRange)partitionKeyRange, collectionRid);
            };
            Func1 executeFunc = request -> this.executeRequestAsync((RxDocumentServiceRequest)request).toObservable();
            DocumentProducer<T> dp = this.createDocumentProducer(collectionRid, targetRange, partitionKeyRangeToContinuationTokenMap.get(targetRange), initialPageSize, this.feedOptions, querySpecForInit, commonRequestHeaders, (Func3<PartitionKeyRange, String, Integer, RxDocumentServiceRequest>)createRequestFunc, executeFunc, (Func0<IDocumentClientRetryPolicy>)((Func0)() -> this.client.getResetSessionTokenRetryPolicy().getRequestPolicy()));
            this.documentProducers.add(dp);
        }
    }

    protected <TContinuationToken> int FindTargetRangeAndExtractContinuationTokens(List<PartitionKeyRange> partitionKeyRanges, Range<String> range) throws DocumentClientException {
        int minIndex;
        if (partitionKeyRanges == null) {
            throw new IllegalArgumentException("partitionKeyRanges can not be null.");
        }
        if (partitionKeyRanges.size() < 1) {
            throw new IllegalArgumentException("partitionKeyRanges must have atleast one element.");
        }
        for (PartitionKeyRange partitionKeyRange : partitionKeyRanges) {
            if (partitionKeyRange != null) continue;
            throw new IllegalArgumentException("partitionKeyRanges can not have null elements.");
        }
        PartitionKeyRange needle = new PartitionKeyRange(null, (String)((Object)range.getMin()), (String)((Object)range.getMax()));
        for (minIndex = 0; minIndex < partitionKeyRanges.size() && !needle.getMinInclusive().equals(partitionKeyRanges.get(minIndex).getMinInclusive()); ++minIndex) {
        }
        if (minIndex == partitionKeyRanges.size()) {
            throw new DocumentClientException(400, String.format("Could not find partition key range for continuation token: {0}", needle));
        }
        return minIndex;
    }

    protected abstract DocumentProducer<T> createDocumentProducer(String var1, PartitionKeyRange var2, String var3, int var4, FeedOptions var5, SqlQuerySpec var6, Map<String, String> var7, Func3<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> var8, Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> var9, Func0<IDocumentClientRetryPolicy> var10);

    @Override
    public abstract Observable<FeedResponse<T>> drainAsync(int var1);

    public void setTop(int newTop) {
        this.top = newTop;
        for (DocumentProducer<T> producer : this.documentProducers) {
            producer.top = newTop;
        }
    }
}

