/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation.planning;

import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageExecutionInterval;

public class StageExecutionIntervalUnconstrained
implements StageExecutionInterval {
    @Override
    public ReservationInterval computeExecutionInterval(Plan plan, ReservationDefinition reservation, ReservationRequest currentReservationStage, boolean allocateLeft, RLESparseResourceAllocation allocations) {
        Long allocationStartTime;
        Long stageArrival = reservation.getArrival();
        Long stageDeadline = reservation.getDeadline();
        ReservationRequestInterpreter jobType = reservation.getReservationRequests().getInterpreter();
        if (allocateLeft) {
            Long allocationEndTime;
            if ((jobType == ReservationRequestInterpreter.R_ORDER || jobType == ReservationRequestInterpreter.R_ORDER_NO_GAP) && (allocationEndTime = Long.valueOf(allocations.getLatestNonNullTime())) != -1L) {
                stageArrival = allocationEndTime;
            }
        } else if ((jobType == ReservationRequestInterpreter.R_ORDER || jobType == ReservationRequestInterpreter.R_ORDER_NO_GAP) && (allocationStartTime = Long.valueOf(allocations.getEarliestStartTime())) != -1L) {
            stageDeadline = allocationStartTime;
        }
        return new ReservationInterval(stageArrival, stageDeadline);
    }
}

