/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.auth;

import com.aliyun.oss.common.auth.BasicCredentials;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.EcsRamRoleCredentialsFetcher;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyuncs.exceptions.ClientException;

public class EcsRamRoleCredentialsProvider
implements CredentialsProvider {
    private BasicCredentials credentials;
    private EcsRamRoleCredentialsFetcher fetcher;
    private int maxRetryTimes = 3;

    public EcsRamRoleCredentialsProvider(String ossAuthServerHost) {
        this.fetcher = new EcsRamRoleCredentialsFetcher(ossAuthServerHost);
    }

    public EcsRamRoleCredentialsProvider withCredentialsFetcher(EcsRamRoleCredentialsFetcher fetcher) {
        this.fetcher = fetcher;
        return this;
    }

    @Override
    public void setCredentials(Credentials creds) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credentials getCredentials() {
        if (this.credentials == null || this.credentials.willSoonExpire()) {
            EcsRamRoleCredentialsProvider ecsRamRoleCredentialsProvider = this;
            synchronized (ecsRamRoleCredentialsProvider) {
                if (this.credentials == null || this.credentials.willSoonExpire()) {
                    try {
                        this.credentials = (BasicCredentials)this.fetcher.fetch(this.maxRetryTimes);
                    }
                    catch (ClientException e) {
                        LogUtils.logException("EcsRoleCredentialsProvider.fetch Exception:", e);
                        return null;
                    }
                }
            }
        }
        return this.credentials;
    }
}

