/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.tools.rumen.DeepCompare;
import org.apache.hadoop.tools.rumen.DeepInequalityException;
import org.apache.hadoop.tools.rumen.ParsedHost;
import org.apache.hadoop.tools.rumen.TreePath;
import org.apache.hadoop.tools.rumen.datatypes.NodeName;

public class LoggedNetworkTopology
implements DeepCompare {
    NodeName name;
    List<LoggedNetworkTopology> children = new ArrayList<LoggedNetworkTopology>();
    private static Set<String> alreadySeenAnySetterAttributes = new TreeSet<String>();

    public LoggedNetworkTopology() {
    }

    @JsonAnySetter
    public void setUnknownAttribute(String attributeName, Object ignored) {
        if (!alreadySeenAnySetterAttributes.contains(attributeName)) {
            alreadySeenAnySetterAttributes.add(attributeName);
            System.err.println("In LoggedJob, we saw the unknown attribute " + attributeName + ".");
        }
    }

    LoggedNetworkTopology(Set<ParsedHost> hosts, String name, int level) {
        this.name = name == null ? NodeName.ROOT : new NodeName(name);
        this.children = null;
        if (level < ParsedHost.numberOfDistances() - 1) {
            HashMap<String, HashSet<ParsedHost>> topologies = new HashMap<String, HashSet<ParsedHost>>();
            for (ParsedHost host : hosts) {
                String thisComponent = host.nameComponent(level);
                HashSet<ParsedHost> thisSet = (HashSet<ParsedHost>)topologies.get(thisComponent);
                if (thisSet == null) {
                    thisSet = new HashSet<ParsedHost>();
                    topologies.put(thisComponent, thisSet);
                }
                thisSet.add(host);
            }
            this.children = new ArrayList<LoggedNetworkTopology>();
            for (Map.Entry ent : topologies.entrySet()) {
                this.children.add(new LoggedNetworkTopology((Set)ent.getValue(), (String)ent.getKey(), level + 1));
            }
        }
    }

    LoggedNetworkTopology(Set<ParsedHost> hosts) {
        this(hosts, null, 0);
    }

    public NodeName getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = new NodeName(name);
    }

    public List<LoggedNetworkTopology> getChildren() {
        return this.children;
    }

    void setChildren(List<LoggedNetworkTopology> children) {
        this.children = children;
    }

    private void compare1(List<LoggedNetworkTopology> c1, List<LoggedNetworkTopology> c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        if (c1 == null || c2 == null || c1.size() != c2.size()) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
        Collections.sort(c1, new TopoSort());
        Collections.sort(c2, new TopoSort());
        for (int i = 0; i < c1.size(); ++i) {
            c1.get(i).deepCompare(c2.get(i), new TreePath(loc, eltname, i));
        }
    }

    @Override
    public void deepCompare(DeepCompare comparand, TreePath loc) throws DeepInequalityException {
        if (!(comparand instanceof LoggedNetworkTopology)) {
            throw new DeepInequalityException("comparand has wrong type", loc);
        }
        LoggedNetworkTopology other = (LoggedNetworkTopology)comparand;
        this.compare1(this.children, other.children, loc, "children");
    }

    static class TopoSort
    implements Comparator<LoggedNetworkTopology>,
    Serializable {
        TopoSort() {
        }

        @Override
        public int compare(LoggedNetworkTopology t1, LoggedNetworkTopology t2) {
            return t1.name.getValue().compareTo(t2.name.getValue());
        }
    }
}

