/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.timeline.GenericObjectMapper;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParseException;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParserForCompareExpr;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimelineStorageUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class TimelineParserForNumericFilters
extends TimelineParserForCompareExpr {
    public TimelineParserForNumericFilters(String expression) {
        super(expression, "Metric Filter");
    }

    @Override
    protected TimelineFilter createFilter() {
        return new TimelineCompareFilter();
    }

    @Override
    protected void setCompareOpToCurrentFilter(TimelineCompareOp compareOp, boolean keyMustExistFlag) {
        ((TimelineCompareFilter)this.getCurrentFilter()).setCompareOp(compareOp, keyMustExistFlag);
    }

    @Override
    protected Object parseValue(String strValue) throws TimelineParseException {
        Object value = null;
        try {
            value = GenericObjectMapper.OBJECT_READER.readValue(strValue);
        }
        catch (IOException e) {
            throw new TimelineParseException("Value cannot be parsed.");
        }
        if (value == null || !TimelineStorageUtils.isIntegralValue(value)) {
            throw new TimelineParseException("Value is not a number.");
        }
        return value;
    }

    @Override
    protected void setValueToCurrentFilter(Object value) {
        TimelineFilter currentFilter = this.getCurrentFilter();
        if (currentFilter != null) {
            ((TimelineCompareFilter)currentFilter).setValue(value);
        }
    }
}

