/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hadoop.shaded.org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbsoluteResourceCapacityCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractQueueCapacityCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PercentageQueueCapacityCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityUpdateContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ReservationQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ResourceCalculationDriver;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.RootCalculationDriver;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.RootQueueCapacityCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.WeightQueueCapacityCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapacitySchedulerQueueCapacityHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CapacitySchedulerQueueCapacityHandler.class);
    private final Map<QueueCapacityVector.ResourceUnitCapacityType, AbstractQueueCapacityCalculator> calculators;
    private final AbstractQueueCapacityCalculator rootCalculator = new RootQueueCapacityCalculator();
    private final RMNodeLabelsManager labelsManager;
    private final Collection<String> definedResources = new LinkedHashSet<String>();
    private final boolean isLegacyQueueMode;

    public CapacitySchedulerQueueCapacityHandler(RMNodeLabelsManager labelsManager, CapacitySchedulerConfiguration configuration) {
        this.calculators = new HashMap<QueueCapacityVector.ResourceUnitCapacityType, AbstractQueueCapacityCalculator>();
        this.labelsManager = labelsManager;
        this.calculators.put(QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE, new AbsoluteResourceCapacityCalculator());
        this.calculators.put(QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE, new PercentageQueueCapacityCalculator());
        this.calculators.put(QueueCapacityVector.ResourceUnitCapacityType.WEIGHT, new WeightQueueCapacityCalculator());
        this.isLegacyQueueMode = configuration.isLegacyQueueMode();
        this.loadResourceNames();
    }

    public QueueCapacityUpdateContext updateChildren(Resource clusterResource, CSQueue queue) {
        ResourceLimits resourceLimits = new ResourceLimits(clusterResource);
        QueueCapacityUpdateContext updateContext = new QueueCapacityUpdateContext(clusterResource, this.labelsManager);
        this.update(queue, updateContext, resourceLimits);
        return updateContext;
    }

    public void updateRoot(CSQueue rootQueue, Resource clusterResource) {
        ResourceLimits resourceLimits = new ResourceLimits(clusterResource);
        QueueCapacityUpdateContext updateContext = new QueueCapacityUpdateContext(clusterResource, this.labelsManager);
        RootCalculationDriver rootCalculationDriver = new RootCalculationDriver(rootQueue, updateContext, this.rootCalculator, this.definedResources);
        rootCalculationDriver.calculateResources();
        rootQueue.refreshAfterResourceCalculation(updateContext.getUpdatedClusterResource(), resourceLimits);
    }

    private void update(CSQueue queue, QueueCapacityUpdateContext updateContext, ResourceLimits resourceLimits) {
        if (queue == null || CollectionUtils.isEmpty(queue.getChildQueues())) {
            return;
        }
        ResourceCalculationDriver resourceCalculationDriver = new ResourceCalculationDriver(queue, updateContext, this.calculators, this.definedResources);
        resourceCalculationDriver.calculateResources();
        this.updateChildrenAfterCalculation(resourceCalculationDriver, resourceLimits);
    }

    private void updateChildrenAfterCalculation(ResourceCalculationDriver resourceCalculationDriver, ResourceLimits resourceLimits) {
        AbstractParentQueue parentQueue = (AbstractParentQueue)resourceCalculationDriver.getQueue();
        for (CSQueue childQueue : parentQueue.getChildQueues()) {
            this.updateQueueCapacities(resourceCalculationDriver, childQueue);
            ResourceLimits childLimit = parentQueue.getResourceLimitsOfChild(childQueue, resourceCalculationDriver.getUpdateContext().getUpdatedClusterResource(), resourceLimits, "", false);
            childQueue.refreshAfterResourceCalculation(resourceCalculationDriver.getUpdateContext().getUpdatedClusterResource(), childLimit);
            this.update(childQueue, resourceCalculationDriver.getUpdateContext(), childLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQueueCapacities(ResourceCalculationDriver resourceCalculationDriver, CSQueue queue) {
        queue.getWriteLock().lock();
        try {
            for (String label : queue.getConfiguredNodeLabels()) {
                if (!this.isLegacyQueueMode) {
                    CapacitySchedulerQueueCapacityHandler.setQueueCapacities(resourceCalculationDriver.getUpdateContext().getUpdatedClusterResource(label), queue, label);
                    continue;
                }
                for (QueueCapacityVector.ResourceUnitCapacityType capacityType : queue.getConfiguredCapacityVector(label).getDefinedCapacityTypes()) {
                    AbstractQueueCapacityCalculator calculator = this.calculators.get((Object)capacityType);
                    calculator.updateCapacitiesAfterCalculation(resourceCalculationDriver, queue, label);
                }
            }
        }
        finally {
            queue.getWriteLock().unlock();
        }
    }

    public static void setQueueCapacities(Resource clusterResource, CSQueue queue, String label) {
        if (!(queue instanceof AbstractCSQueue)) {
            return;
        }
        AbstractCSQueue csQueue = (AbstractCSQueue)queue;
        if ((csQueue instanceof ReservationQueue || csQueue instanceof PlanQueue) && Stream.of(clusterResource.getResources()).map(ResourceInformation::getValue).noneMatch(num -> num > 0L)) {
            return;
        }
        ResourceCalculator resourceCalculator = csQueue.resourceCalculator;
        CSQueue parent = queue.getParent();
        if (parent == null) {
            return;
        }
        float result = resourceCalculator.divide(clusterResource, queue.getQueueResourceQuotas().getEffectiveMinResource(label), parent.getQueueResourceQuotas().getEffectiveMinResource(label));
        queue.getQueueCapacities().setCapacity(label, Float.isInfinite(result) ? 0.0f : result);
        result = resourceCalculator.divide(clusterResource, queue.getQueueResourceQuotas().getEffectiveMaxResource(label), parent.getQueueResourceQuotas().getEffectiveMaxResource(label));
        queue.getQueueCapacities().setMaximumCapacity(label, Float.isInfinite(result) ? 0.0f : result);
        csQueue.updateAbsoluteCapacities();
    }

    private void loadResourceNames() {
        HashSet resources = new HashSet(ResourceUtils.getResourceTypes().keySet());
        if (resources.contains("memory-mb")) {
            resources.remove("memory-mb");
            this.definedResources.add("memory-mb");
        }
        if (resources.contains("vcores")) {
            resources.remove("vcores");
            this.definedResources.add("vcores");
        }
        this.definedResources.addAll(resources);
    }
}

