/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FSPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FairQueuePlacementUtils;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SecondaryGroupExistingPlacementRule
extends FSPlacementRule {
    private static final Logger LOG = LoggerFactory.getLogger(SecondaryGroupExistingPlacementRule.class);
    private Groups groupProvider;

    @Override
    public boolean initialize(ResourceScheduler scheduler) throws IOException {
        super.initialize(scheduler);
        this.groupProvider = Groups.getUserToGroupsMappingService((Configuration)((FairScheduler)scheduler).getConfig());
        return true;
    }

    @Override
    public ApplicationPlacementContext getPlacementForApp(ApplicationSubmissionContext asc, String user) throws YarnException {
        Set groupSet;
        try {
            groupSet = this.groupProvider.getGroupsSet(user);
        }
        catch (IOException ioe) {
            throw new YarnException("Group resolution failed", (Throwable)ioe);
        }
        String parentQueue = null;
        PlacementRule parentRule = this.getParentRule();
        if (parentRule != null) {
            LOG.debug("SecondaryGroupExisting rule: parent rule found: {}", (Object)parentRule.getName());
            ApplicationPlacementContext parent = parentRule.getPlacementForApp(asc, user);
            if (parent == null || this.getQueueManager().getQueue(parent.getQueue()) instanceof FSLeafQueue) {
                LOG.debug("SecondaryGroupExisting rule: parent rule failed");
                return null;
            }
            parentQueue = parent.getQueue();
            LOG.debug("SecondaryGroupExisting rule: parent rule result: {}", (Object)parentQueue);
        }
        Iterator it = groupSet.iterator();
        while (it.hasNext()) {
            String group = FairQueuePlacementUtils.cleanName((String)it.next());
            String queueName = parentQueue == null ? FairQueuePlacementUtils.assureRoot(group) : parentQueue + "." + group;
            if (!this.configuredQueue(queueName)) continue;
            return new ApplicationPlacementContext(queueName);
        }
        return null;
    }
}

