/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.Device;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.DevicePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.DockerCommandPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.NodeResourceUpdaterPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.ResourcePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework.AssignedDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework.DeviceMappingManager;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework.DeviceResourceDockerRuntimePluginImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework.DeviceResourceHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework.DeviceResourceUpdaterImpl;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.NMDeviceResourceInfo;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.NMResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevicePluginAdapter
implements ResourcePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(DevicePluginAdapter.class);
    private final String resourceName;
    private final DevicePlugin devicePlugin;
    private DeviceMappingManager deviceMappingManager;
    private DeviceResourceHandlerImpl deviceResourceHandler;
    private DeviceResourceUpdaterImpl deviceResourceUpdater;
    private DeviceResourceDockerRuntimePluginImpl deviceDockerCommandPlugin;

    @VisibleForTesting
    public void setDeviceResourceHandler(DeviceResourceHandlerImpl deviceResourceHandler) {
        this.deviceResourceHandler = deviceResourceHandler;
    }

    public DevicePluginAdapter(String name, DevicePlugin dp, DeviceMappingManager dmm) {
        this.deviceMappingManager = dmm;
        this.resourceName = name;
        this.devicePlugin = dp;
    }

    public DeviceMappingManager getDeviceMappingManager() {
        return this.deviceMappingManager;
    }

    public DevicePlugin getDevicePlugin() {
        return this.devicePlugin;
    }

    @Override
    public void initialize(Context context) throws YarnException {
        this.deviceDockerCommandPlugin = new DeviceResourceDockerRuntimePluginImpl(this.resourceName, this.devicePlugin, this);
        this.deviceResourceUpdater = new DeviceResourceUpdaterImpl(this.resourceName, this.devicePlugin);
        LOG.info(this.resourceName + " plugin adapter initialized");
    }

    @Override
    public ResourceHandler createResourceHandler(Context nmContext, CGroupsHandler cGroupsHandler, PrivilegedOperationExecutor privilegedOperationExecutor) {
        this.deviceResourceHandler = new DeviceResourceHandlerImpl(this.resourceName, this, this.deviceMappingManager, cGroupsHandler, privilegedOperationExecutor, nmContext);
        return this.deviceResourceHandler;
    }

    @Override
    public NodeResourceUpdaterPlugin getNodeResourceHandlerInstance() {
        return this.deviceResourceUpdater;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public DockerCommandPlugin getDockerCommandPluginInstance() {
        return this.deviceDockerCommandPlugin;
    }

    @Override
    public NMResourceInfo getNMResourceInfo() throws YarnException {
        ArrayList<Device> allowed = new ArrayList<Device>((Collection)this.deviceMappingManager.getAllAllowedDevices().get(this.resourceName));
        ArrayList<AssignedDevice> assigned = new ArrayList<AssignedDevice>();
        Map<Device, ContainerId> assignedMap = this.deviceMappingManager.getAllUsedDevices().get(this.resourceName);
        for (Map.Entry<Device, ContainerId> entry : assignedMap.entrySet()) {
            assigned.add(new AssignedDevice(entry.getValue(), entry.getKey()));
        }
        return new NMDeviceResourceInfo(allowed, assigned);
    }

    public DeviceResourceHandlerImpl getDeviceResourceHandler() {
        return this.deviceResourceHandler;
    }

    public String toString() {
        return DevicePluginAdapter.class.getName();
    }
}

