/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool.jmx;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.shaded.org.glassfish.gmbal.Description;
import org.apache.hadoop.shaded.org.glassfish.gmbal.GmbalMBean;
import org.apache.hadoop.shaded.org.glassfish.gmbal.ManagedAttribute;
import org.apache.hadoop.shaded.org.glassfish.gmbal.ManagedObject;
import org.apache.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.GrizzlyJmxManager;
import org.apache.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool.ThreadPoolProbe;

@ManagedObject
@Description(value="Grizzly ThreadPool (typically shared between Transport instances).")
public class ThreadPool
extends JmxObject {
    private final AbstractThreadPool threadPool;
    private final ThreadPoolProbe probe = new JmxThreadPoolProbe();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicInteger currentAllocatedThreadCount = new AtomicInteger();
    private final AtomicInteger totalAllocatedThreadCount = new AtomicInteger();
    private final AtomicInteger currentQueuedTasksCount = new AtomicInteger();
    private final AtomicLong totalCompletedTasksCount = new AtomicLong();
    private final AtomicInteger totalTaskQueueOverflowCount = new AtomicInteger();

    public ThreadPool(AbstractThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public String getJmxName() {
        return "ThreadPool";
    }

    @Override
    protected void onRegister(GrizzlyJmxManager mom, GmbalMBean bean) {
        this.threadPool.getMonitoringConfig().addProbes(this.probe);
    }

    @Override
    protected void onDeregister(GrizzlyJmxManager mom) {
        this.threadPool.getMonitoringConfig().removeProbes(this.probe);
    }

    @ManagedAttribute(id="thread-pool-type")
    @Description(value="The Java type of the thread pool implementation being used.")
    public String getPoolType() {
        return this.threadPool.getClass().getName();
    }

    @ManagedAttribute(id="thread-pool-started")
    @Description(value="Indiciates whether or not the thread pool has been started.")
    public boolean isStarted() {
        return this.started.get();
    }

    @ManagedAttribute(id="thread-pool-max-num-threads")
    @Description(value="The maximum number of the threads allowed by this thread pool.")
    public int getMaxAllowedThreads() {
        return this.threadPool.getConfig().getMaxPoolSize();
    }

    @ManagedAttribute(id="thread-pool-core-pool-size")
    @Description(value="The initial/minimum number of threads managed by this thread pool.")
    public int getCorePoolSize() {
        return this.threadPool.getConfig().getCorePoolSize();
    }

    @ManagedAttribute(id="thread-pool-allocated-thread-count")
    @Description(value="The current number of threads managed by this thread pool.")
    public int getCurrentAllocatedThreadCount() {
        return this.currentAllocatedThreadCount.get();
    }

    @ManagedAttribute(id="thread-pool-total-allocated-thread-count")
    @Description(value="The total number of threads allocated during the lifetime of this thread pool.")
    public int getTotalAllocatedThreadCount() {
        return this.totalAllocatedThreadCount.get();
    }

    @ManagedAttribute(id="thread-pool-queued-task-count")
    @Description(value="The number of tasks currently being processed by this thread pool.")
    public int getCurrentTaskCount() {
        return this.currentQueuedTasksCount.get();
    }

    @ManagedAttribute(id="thread-pool-total-completed-tasks-count")
    @Description(value="The total number of tasks that have been processed by this thread pool.")
    public long getTotalCompletedTasksCount() {
        return this.totalCompletedTasksCount.get();
    }

    @ManagedAttribute(id="thread-pool-task-queue-overflow-count")
    @Description(value="The total number of times the task queue of this thread pool has been saturated.")
    public int getTotalTaskQueueOverflowCount() {
        return this.totalTaskQueueOverflowCount.get();
    }

    private final class JmxThreadPoolProbe
    implements ThreadPoolProbe {
        private JmxThreadPoolProbe() {
        }

        @Override
        public void onThreadPoolStartEvent(AbstractThreadPool threadPool) {
            ThreadPool.this.started.compareAndSet(false, true);
        }

        @Override
        public void onThreadPoolStopEvent(AbstractThreadPool threadPool) {
            ThreadPool.this.started.compareAndSet(true, false);
        }

        @Override
        public void onThreadAllocateEvent(AbstractThreadPool threadPool, Thread thread) {
            ThreadPool.this.currentAllocatedThreadCount.incrementAndGet();
            ThreadPool.this.totalAllocatedThreadCount.incrementAndGet();
        }

        @Override
        public void onThreadReleaseEvent(AbstractThreadPool threadPool, Thread thread) {
            ThreadPool.this.currentAllocatedThreadCount.decrementAndGet();
        }

        @Override
        public void onMaxNumberOfThreadsEvent(AbstractThreadPool threadPool, int maxNumberOfThreads) {
        }

        @Override
        public void onTaskQueueEvent(AbstractThreadPool threadPool, Runnable task) {
            ThreadPool.this.currentQueuedTasksCount.incrementAndGet();
        }

        @Override
        public void onTaskDequeueEvent(AbstractThreadPool threadPool, Runnable task) {
            ThreadPool.this.currentQueuedTasksCount.decrementAndGet();
        }

        @Override
        public void onTaskCompleteEvent(AbstractThreadPool threadPool, Runnable task) {
            ThreadPool.this.totalCompletedTasksCount.incrementAndGet();
        }

        @Override
        public void onTaskQueueOverflowEvent(AbstractThreadPool threadPool) {
            ThreadPool.this.totalTaskQueueOverflowCount.incrementAndGet();
        }
    }
}

