/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.messages;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.MessageAppender;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.util.Utf8PartialBuilder;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.endpoints.JsrAnnotatedEventDriver;

public class TextPartialOnMessage
implements MessageAppender {
    private final JsrAnnotatedEventDriver driver;
    private final Utf8PartialBuilder utf8Partial;
    private boolean finished;

    public TextPartialOnMessage(JsrAnnotatedEventDriver driver) {
        this.driver = driver;
        this.finished = false;
        this.utf8Partial = new Utf8PartialBuilder();
    }

    public void appendFrame(ByteBuffer payload, boolean isLast) throws IOException {
        if (this.finished) {
            throw new IOException("Cannot append to finished buffer");
        }
        String text = this.utf8Partial.toPartialString(payload);
        this.driver.onPartialTextMessage(text, isLast);
    }

    public void messageComplete() {
        this.finished = true;
    }
}

