/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.erasurecode;

import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.ErasureCodingWorker;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedBlockChecksumReconstructor;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedReconstructionInfo;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.MD5Hash;

@InterfaceAudience.Private
public class StripedBlockChecksumMd5CrcReconstructor
extends StripedBlockChecksumReconstructor {
    private MD5Hash md5;
    private MessageDigest digester;

    public StripedBlockChecksumMd5CrcReconstructor(ErasureCodingWorker worker, StripedReconstructionInfo stripedReconInfo, DataOutputBuffer checksumWriter, long requestedBlockLength) throws IOException {
        super(worker, stripedReconInfo, checksumWriter, requestedBlockLength);
    }

    @Override
    public Object getDigestObject() {
        return this.md5;
    }

    @Override
    void prepareDigester() throws IOException {
        this.digester = MD5Hash.getDigester();
    }

    @Override
    void updateDigester(byte[] checksumBytes, int dataBytesPerChecksum) throws IOException {
        if (this.digester == null) {
            throw new IOException(String.format("Called updatedDigester with checksumBytes.length=%d, dataBytesPerChecksum=%d but digester is null", checksumBytes.length, dataBytesPerChecksum));
        }
        this.digester.update(checksumBytes, 0, checksumBytes.length);
    }

    @Override
    void commitDigest() throws IOException {
        if (this.digester == null) {
            throw new IOException("Called commitDigest() but digester is null");
        }
        byte[] digest = this.digester.digest();
        this.md5 = new MD5Hash(digest);
        this.md5.write((DataOutput)this.getChecksumWriter());
    }
}

