/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.aliasmap;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMap;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMapProtocol;
import org.apache.hadoop.shaded.org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ITestInMemoryAliasMap {
    private InMemoryAliasMap aliasMap;
    private File tempDirectory;
    private static String bpid = "bpid-0";

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        File temp = Files.createTempDirectory("seagull", new FileAttribute[0]).toFile();
        this.tempDirectory = new File(temp, bpid);
        this.tempDirectory.mkdirs();
        conf.set("dfs.provided.aliasmap.inmemory.leveldb.dir", temp.getAbsolutePath());
        this.aliasMap = InMemoryAliasMap.init(conf, bpid);
    }

    @After
    public void tearDown() throws Exception {
        this.aliasMap.close();
        FileUtils.deleteDirectory((File)this.tempDirectory);
    }

    @Test
    public void readNotFoundReturnsNothing() throws IOException {
        Block block = new Block(42L, 43L, 44L);
        Optional<ProvidedStorageLocation> actualProvidedStorageLocationOpt = this.aliasMap.read(block);
        Assert.assertFalse((boolean)actualProvidedStorageLocationOpt.isPresent());
    }

    @Test
    public void readWrite() throws Exception {
        Block block = new Block(42L, 43L, 44L);
        Path path = new Path("eagle", "mouse");
        long offset = 47L;
        long length = 48L;
        int nonceSize = 4;
        byte[] nonce = new byte[nonceSize];
        Arrays.fill(nonce, 0, nonceSize - 1, Byte.parseByte("0011", 2));
        ProvidedStorageLocation expectedProvidedStorageLocation = new ProvidedStorageLocation(path, offset, length, nonce);
        this.aliasMap.write(block, expectedProvidedStorageLocation);
        Optional<ProvidedStorageLocation> actualProvidedStorageLocationOpt = this.aliasMap.read(block);
        Assert.assertTrue((boolean)actualProvidedStorageLocationOpt.isPresent());
        Assert.assertEquals((Object)expectedProvidedStorageLocation, (Object)actualProvidedStorageLocationOpt.get());
    }

    @Test
    public void list() throws IOException {
        Block block1 = new Block(42L, 43L, 44L);
        Block block2 = new Block(43L, 44L, 45L);
        Block block3 = new Block(44L, 45L, 46L);
        Path path = new Path("eagle", "mouse");
        int nonceSize = 4;
        byte[] nonce = new byte[nonceSize];
        Arrays.fill(nonce, 0, nonceSize - 1, Byte.parseByte("0011", 2));
        ProvidedStorageLocation expectedProvidedStorageLocation1 = new ProvidedStorageLocation(path, 47L, 48L, nonce);
        ProvidedStorageLocation expectedProvidedStorageLocation2 = new ProvidedStorageLocation(path, 48L, 49L, nonce);
        ProvidedStorageLocation expectedProvidedStorageLocation3 = new ProvidedStorageLocation(path, 49L, 50L, nonce);
        this.aliasMap.write(block1, expectedProvidedStorageLocation1);
        this.aliasMap.write(block2, expectedProvidedStorageLocation2);
        this.aliasMap.write(block3, expectedProvidedStorageLocation3);
        InMemoryAliasMapProtocol.IterationResult list = this.aliasMap.list(Optional.empty());
        Assert.assertEquals((long)3L, (long)list.getFileRegions().size());
        Assert.assertFalse((boolean)list.getNextBlock().isPresent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshot() throws Exception {
        Block block1 = new Block(100L);
        Block block2 = new Block(200L);
        Path path = new Path("users", "alice");
        ProvidedStorageLocation remoteLocation = new ProvidedStorageLocation(path, 0L, 1000L, new byte[0]);
        this.aliasMap.write(block1, remoteLocation);
        File snapshotFile = InMemoryAliasMap.createSnapshot(this.aliasMap);
        this.aliasMap.write(block2, remoteLocation);
        InMemoryAliasMap snapshotAliasMap = null;
        Configuration newConf = new Configuration();
        newConf.set("dfs.provided.aliasmap.inmemory.leveldb.dir", snapshotFile.getAbsolutePath());
        try {
            snapshotAliasMap = InMemoryAliasMap.init(newConf, bpid);
            Assert.assertTrue((boolean)snapshotAliasMap.read(block1).isPresent());
            Assert.assertFalse((boolean)snapshotAliasMap.read(block2).isPresent());
        }
        finally {
            if (snapshotAliasMap != null) {
                snapshotAliasMap.close();
            }
        }
    }
}

