/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.GpuDeviceInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GpuDeviceInformationParser {
    private static final Logger LOG = LoggerFactory.getLogger(GpuDeviceInformationParser.class);
    public static final String GPU_SCRIPT_REFERENCE = "GPU device detection script";
    private final Unmarshaller unmarshaller;
    private final XMLReader xmlReader;

    public GpuDeviceInformationParser() throws YarnException {
        try {
            SAXParserFactory parserFactory = this.initSaxParserFactory();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GpuDeviceInformation.class});
            this.xmlReader = parserFactory.newSAXParser().getXMLReader();
            this.unmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (Exception e) {
            String msg = "Exception while initializing parser for GPU device detection script";
            LOG.error(msg, (Throwable)e);
            throw new YarnException(msg, (Throwable)e);
        }
    }

    private SAXParserFactory initSaxParserFactory() throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        spf.setFeature("http://xml.org/sax/features/validation", false);
        return spf;
    }

    public synchronized GpuDeviceInformation parseXml(String xmlContent) throws YarnException {
        InputSource inputSource = new InputSource(new StringReader(xmlContent));
        SAXSource source = new SAXSource(this.xmlReader, inputSource);
        try {
            return (GpuDeviceInformation)this.unmarshaller.unmarshal((Source)source);
        }
        catch (JAXBException e) {
            String msg = "Failed to parse XML output of GPU device detection script!";
            LOG.error(msg, (Throwable)e);
            throw new YarnException(msg, (Throwable)e);
        }
    }
}

