/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin;

import java.util.Objects;

public final class DeviceRegisterRequest {
    private final String pluginVersion;
    private final String resourceName;

    private DeviceRegisterRequest(Builder builder) {
        this.resourceName = Objects.requireNonNull(builder.resourceName);
        this.pluginVersion = builder.pluginVersion;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public static final class Builder {
        private String pluginVersion;
        private String resourceName;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public DeviceRegisterRequest build() {
            return new DeviceRegisterRequest(this);
        }

        public Builder setResourceName(String resName) {
            this.resourceName = resName;
            return this;
        }

        public Builder setPluginVersion(String plVersion) {
            this.pluginVersion = plVersion;
            return this;
        }
    }
}

