/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer.workloadgenerator;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class VirtualRecordReader<K, V>
extends RecordReader<K, V> {
    private int durationMs;
    private long startTimestampInMs;
    private long endTimestampInMs;
    private int numRows = 1;

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.durationMs = conf.getInt("createfile.duration-min", 0) * 60 * 1000;
        this.startTimestampInMs = conf.getInt("start_timestamp_ms", 0);
        this.endTimestampInMs = this.startTimestampInMs + (long)this.durationMs;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.numRows > 0) {
            --this.numRows;
            return true;
        }
        return false;
    }

    public K getCurrentKey() throws IOException, InterruptedException {
        return (K)NullWritable.get();
    }

    public V getCurrentValue() throws IOException, InterruptedException {
        return (V)NullWritable.get();
    }

    public float getProgress() throws IOException, InterruptedException {
        long remainingMs = this.endTimestampInMs - System.currentTimeMillis();
        return (float)remainingMs * 100.0f / (float)this.durationMs;
    }

    public void close() throws IOException {
    }
}

