/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class SampleStat {
    private final MinMax minmax = new MinMax();
    private long numSamples = 0L;
    private double mean = 0.0;
    private double s = 0.0;

    public void reset() {
        this.numSamples = 0L;
        this.mean = 0.0;
        this.s = 0.0;
        this.minmax.reset();
    }

    void reset(long numSamples1, double mean1, double s1, MinMax minmax1) {
        this.numSamples = numSamples1;
        this.mean = mean1;
        this.s = s1;
        this.minmax.reset(minmax1);
    }

    public void copyTo(SampleStat other) {
        other.reset(this.numSamples, this.mean, this.s, this.minmax);
    }

    public SampleStat add(double x) {
        this.minmax.add(x);
        return this.add(1L, x);
    }

    public SampleStat add(long nSamples, double xTotal) {
        this.numSamples += nSamples;
        double x = xTotal / (double)nSamples;
        double meanOld = this.mean;
        this.mean += (double)nSamples / (double)this.numSamples * (x - meanOld);
        this.s += (double)nSamples * (x - meanOld) * (x - this.mean);
        return this;
    }

    public long numSamples() {
        return this.numSamples;
    }

    public double total() {
        return this.mean * (double)this.numSamples;
    }

    public double mean() {
        return this.numSamples > 0L ? this.mean : 0.0;
    }

    public double variance() {
        return this.numSamples > 1L ? this.s / (double)(this.numSamples - 1L) : 0.0;
    }

    public double stddev() {
        return Math.sqrt(this.variance());
    }

    public double min() {
        return this.minmax.min();
    }

    public double max() {
        return this.minmax.max();
    }

    public String toString() {
        try {
            return "Samples = " + this.numSamples() + "  Min = " + this.min() + "  Mean = " + this.mean() + "  Std Dev = " + this.stddev() + "  Max = " + this.max();
        }
        catch (Throwable t) {
            return super.toString();
        }
    }

    public static class MinMax {
        static final double DEFAULT_MIN_VALUE = 3.4028234663852886E38;
        static final double DEFAULT_MAX_VALUE = (double)1.4E-45f;
        private double min = 3.4028234663852886E38;
        private double max = 1.4E-45f;

        public void add(double value) {
            if (value > this.max) {
                this.max = value;
            }
            if (value < this.min) {
                this.min = value;
            }
        }

        public double min() {
            return this.min;
        }

        public double max() {
            return this.max;
        }

        public void reset() {
            this.min = 3.4028234663852886E38;
            this.max = 1.4E-45f;
        }

        public void reset(MinMax other) {
            this.min = other.min();
            this.max = other.max();
        }
    }
}

