/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.observers.Subscribers;
import rx.subscriptions.Subscriptions;

public final class TransformerDelayFinalUnsubscribe<T>
implements Observable.Transformer<T, T> {
    private final long delayMs;
    private final Scheduler scheduler;

    public TransformerDelayFinalUnsubscribe(long delayMs, Scheduler scheduler) {
        this.delayMs = delayMs;
        this.scheduler = scheduler;
    }

    public Observable<T> call(final Observable<T> o) {
        final AtomicInteger count = new AtomicInteger();
        final AtomicReference extra = new AtomicReference();
        final AtomicReference worker = new AtomicReference();
        final Object lock = new Object();
        return o.doOnSubscribe(new Action0(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                if (count.incrementAndGet() == 1) {
                    Scheduler.Worker w;
                    Subscriber sub;
                    Object object = lock;
                    synchronized (object) {
                        if (extra.get() == null) {
                            sub = TransformerDelayFinalUnsubscribe.doNothing();
                            extra.set(sub);
                        } else {
                            sub = null;
                        }
                        w = (Scheduler.Worker)worker.get();
                        worker.set(null);
                    }
                    if (w != null) {
                        w.unsubscribe();
                    }
                    if (sub != null) {
                        o.subscribe(sub);
                    }
                } else {
                    Scheduler.Worker w;
                    Object object = lock;
                    synchronized (object) {
                        w = (Scheduler.Worker)worker.get();
                        worker.set(null);
                    }
                    if (w != null) {
                        w.unsubscribe();
                    }
                }
            }
        }).lift(new OperatorAddToSubscription(new Action0(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                if (count.decrementAndGet() == 0) {
                    Scheduler.Worker newW;
                    Scheduler.Worker w;
                    Object object = lock;
                    synchronized (object) {
                        w = (Scheduler.Worker)worker.get();
                        newW = TransformerDelayFinalUnsubscribe.this.scheduler.createWorker();
                        worker.set(newW);
                    }
                    if (w != null) {
                        w.unsubscribe();
                    }
                    newW.schedule(new Action0(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void call() {
                            Subscriber sub;
                            Object object = lock;
                            synchronized (object) {
                                sub = (Subscriber)extra.get();
                                extra.set(null);
                            }
                            sub.unsubscribe();
                            newW.unsubscribe();
                            worker.compareAndSet(newW, null);
                        }
                    }, TransformerDelayFinalUnsubscribe.this.delayMs, TimeUnit.MILLISECONDS);
                }
            }
        }));
    }

    private static <T> Subscriber<T> doNothing() {
        return new Subscriber<T>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(T t) {
            }
        };
    }

    private static final class OperatorAddToSubscription<T>
    implements Observable.Operator<T, T> {
        private final Action0 action;

        OperatorAddToSubscription(Action0 action) {
            this.action = action;
        }

        public Subscriber<? super T> call(Subscriber<? super T> child) {
            Subscriber parent = Subscribers.wrap(child);
            child.add(Subscriptions.create((Action0)this.action));
            return parent;
        }
    }
}

