/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.rx.Actions;
import com.github.davidmoten.rx.Bytes;
import com.github.davidmoten.rx.Checked;
import com.github.davidmoten.rx.Functions;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import rx.Observable;
import rx.Observer;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.observables.SyncOnSubscribe;

public final class ObservableServerSocket {
    private ObservableServerSocket() {
    }

    public static Observable<Observable<byte[]>> create(Func0<? extends ServerSocket> serverSocketFactory, int timeoutMs, int bufferSize, Action0 preAcceptAction, int acceptTimeoutMs, Func1<? super Socket, Boolean> acceptSocket) {
        Func1<ServerSocket, Observable<Observable<byte[]>>> observableFactory = ObservableServerSocket.createObservableFactory(timeoutMs, bufferSize, preAcceptAction, acceptSocket);
        return Observable.using(ObservableServerSocket.createServerSocketFactory(serverSocketFactory, acceptTimeoutMs), observableFactory, (Action1)new Action1<ServerSocket>(){

            public void call(ServerSocket ss) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, (boolean)true);
    }

    private static Func0<ServerSocket> createServerSocketFactory(final Func0<? extends ServerSocket> serverSocketFactory, final int acceptTimeoutMs) {
        return Checked.f0(new Checked.F0<ServerSocket>(){

            @Override
            public ServerSocket call() throws Exception {
                return ObservableServerSocket.createServerSocket((Func0<? extends ServerSocket>)serverSocketFactory, acceptTimeoutMs);
            }
        });
    }

    private static ServerSocket createServerSocket(Func0<? extends ServerSocket> serverSocketCreator, long timeoutMs) throws IOException {
        ServerSocket s = (ServerSocket)serverSocketCreator.call();
        s.setSoTimeout((int)timeoutMs);
        return s;
    }

    private static Func1<ServerSocket, Observable<Observable<byte[]>>> createObservableFactory(final int timeoutMs, final int bufferSize, final Action0 preAcceptAction, final Func1<? super Socket, Boolean> acceptSocket) {
        return new Func1<ServerSocket, Observable<Observable<byte[]>>>(){

            public Observable<Observable<byte[]>> call(ServerSocket serverSocket) {
                return ObservableServerSocket.createServerSocketObservable(serverSocket, timeoutMs, bufferSize, preAcceptAction, (Func1<? super Socket, Boolean>)acceptSocket);
            }
        };
    }

    private static Observable<Observable<byte[]>> createServerSocketObservable(ServerSocket serverSocket, final long timeoutMs, final int bufferSize, final Action0 preAcceptAction, final Func1<? super Socket, Boolean> acceptSocket) {
        return Observable.create((SyncOnSubscribe)SyncOnSubscribe.createSingleState(Functions.constant0(serverSocket), (Action2)new Action2<ServerSocket, Observer<? super Observable<byte[]>>>(){

            public void call(ServerSocket ss, Observer<? super Observable<byte[]>> observer) {
                ObservableServerSocket.acceptConnection(timeoutMs, bufferSize, ss, (Observer<? super Observable<byte[]>>)observer, preAcceptAction, (Func1<? super Socket, Boolean>)acceptSocket);
            }
        }));
    }

    private static void acceptConnection(long timeoutMs, int bufferSize, ServerSocket ss, Observer<? super Observable<byte[]>> observer, Action0 preAcceptAction, Func1<? super Socket, Boolean> acceptSocket) {
        while (true) {
            try {
                Socket socket;
                while (true) {
                    preAcceptAction.call();
                    socket = ss.accept();
                    if (((Boolean)acceptSocket.call((Object)socket)).booleanValue()) break;
                    ObservableServerSocket.closeQuietly(socket);
                }
                observer.onNext(ObservableServerSocket.createSocketObservable(socket, timeoutMs, bufferSize));
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            catch (IOException e) {
                observer.onError((Throwable)e);
            }
            break;
        }
    }

    private static void closeQuietly(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Observable<byte[]> createSocketObservable(final Socket socket, long timeoutMs, final int bufferSize) {
        ObservableServerSocket.setTimeout(socket, timeoutMs);
        return Observable.using(Checked.f0(new Checked.F0<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                return socket.getInputStream();
            }
        }), (Func1)new Func1<InputStream, Observable<byte[]>>(){

            public Observable<byte[]> call(InputStream is) {
                return Bytes.from(is, bufferSize);
            }
        }, Actions.close(), (boolean)true);
    }

    private static void setTimeout(Socket socket, long timeoutMs) {
        try {
            socket.setSoTimeout((int)timeoutMs);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }
}

