/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.fedbalance.procedure;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BalanceProcedure<T extends BalanceProcedure>
implements Writable {
    public static final Logger LOG = LoggerFactory.getLogger(BalanceProcedure.class);
    private String nextProcedure;
    private String name;
    private long delayDuration;
    private BalanceJob job;

    public BalanceProcedure() {
    }

    public BalanceProcedure(String name, String nextProcedure, long delayDuration) {
        this();
        this.name = name;
        this.nextProcedure = nextProcedure;
        this.delayDuration = delayDuration;
    }

    public BalanceProcedure(String name, long delayDuration) {
        this(name, "NONE", delayDuration);
    }

    public abstract boolean execute() throws RetryException, IOException;

    public long delayMillisBeforeRetry() {
        return this.delayDuration;
    }

    protected boolean isSchedulerShutdown() {
        return this.job.isSchedulerShutdown();
    }

    protected void setNextProcedure(String nextProcedure) {
        this.nextProcedure = nextProcedure;
    }

    void setJob(BalanceJob job) {
        this.job = job;
    }

    public String nextProcedure() {
        return this.nextProcedure;
    }

    public String name() {
        return this.name;
    }

    public void write(DataOutput out) throws IOException {
        if (this.nextProcedure == null) {
            Text.writeString((DataOutput)out, (String)"NONE");
        } else {
            Text.writeString((DataOutput)out, (String)this.nextProcedure);
        }
        Text.writeString((DataOutput)out, (String)this.name);
        new LongWritable(this.delayDuration).write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.nextProcedure = Text.readString((DataInput)in);
        this.name = Text.readString((DataInput)in);
        this.delayDuration = BalanceProcedure.readLong(in);
    }

    private static long readLong(DataInput in) throws IOException {
        LongWritable delayWritable = new LongWritable();
        delayWritable.readFields(in);
        return delayWritable.get();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.nextProcedure).append((Object)this.name).append(this.delayDuration).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BalanceProcedure rhs = (BalanceProcedure)obj;
        return new EqualsBuilder().append((Object)this.nextProcedure, (Object)rhs.nextProcedure).append((Object)this.name, (Object)rhs.name).append(this.delayDuration, rhs.delayDuration).build();
    }

    public String toString() {
        return this.name + ":" + this.getClass().getName();
    }

    public static class RetryException
    extends Exception {
    }
}

