/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.InternalServerErrorException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ConflictException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ForbiddenException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GoneException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.LockedException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.MethodNotAllowedException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.PartitionKeyRangeGoneException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.PreconditionFailedException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RequestEntityTooLargeException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RequestRateTooLargeException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RequestTimeoutException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RetryWithException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ServiceUnavailableException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.UnauthorizedException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdConstants;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdContext;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdContextNegotiator;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdContextRequest;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestArgs;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdResponse;
import com.microsoft.azure.cosmosdb.rx.internal.BadRequestException;
import com.microsoft.azure.cosmosdb.rx.internal.InvalidPartitionException;
import com.microsoft.azure.cosmosdb.rx.internal.NotFoundException;
import com.microsoft.azure.cosmosdb.rx.internal.PartitionIsMigratingException;
import com.microsoft.azure.cosmosdb.rx.internal.PartitionKeyRangeIsSplittingException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CoalescingBufferQueue;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RntbdRequestManager
implements ChannelInboundHandler,
ChannelOutboundHandler,
ChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(RntbdRequestManager.class);
    private final CompletableFuture<RntbdContext> contextFuture = new CompletableFuture();
    private final CompletableFuture<RntbdContextRequest> contextRequestFuture = new CompletableFuture();
    private final ConcurrentHashMap<UUID, PendingRequest> pendingRequests = new ConcurrentHashMap();
    private volatile ChannelHandlerContext context;
    private volatile PendingRequest currentRequest;
    private volatile CoalescingBufferQueue pendingWrites;

    public void cancelStoreResponseFuture(UUID activityId) {
        Objects.requireNonNull(activityId, "activityId");
        this.removePendingRequest(activityId).getResponseFuture().cancel(true);
    }

    public void completeStoreResponseFutureExceptionally(UUID activityId, Throwable cause) {
        Objects.requireNonNull(activityId, "activityId");
        Objects.requireNonNull(cause, "cause");
        this.removePendingRequest(activityId).getResponseFuture().completeExceptionally(cause);
    }

    public CompletableFuture<StoreResponse> createStoreResponseFuture(RntbdRequestArgs requestArgs) {
        Objects.requireNonNull(requestArgs, "requestArgs");
        this.currentRequest = this.pendingRequests.compute(requestArgs.getActivityId(), (activityId, pendingRequest) -> {
            if (pendingRequest == null) {
                pendingRequest = new PendingRequest(requestArgs);
                logger.trace("{} created new pending request", pendingRequest);
            } else {
                logger.trace("{} renewed existing pending request", pendingRequest);
            }
            return pendingRequest;
        });
        this.traceOperation(logger, this.context, "createStoreResponseFuture", new Object[0]);
        return this.currentRequest.getResponseFuture();
    }

    void traceOperation(Logger logger, ChannelHandlerContext context, String operationName, Object ... args) {
        if (logger.isTraceEnabled()) {
            BigDecimal lifetime;
            long birthTime;
            if (this.currentRequest == null) {
                birthTime = System.nanoTime();
                lifetime = BigDecimal.ZERO;
            } else {
                birthTime = this.currentRequest.getBirthTime();
                lifetime = BigDecimal.valueOf(this.currentRequest.getLifetime().toNanos(), 6);
            }
            logger.info("{},{},\"{}({})\",\"{}\",\"{}\"", new Object[]{birthTime, lifetime, operationName, Stream.of(args).map(arg -> arg == null ? "null" : arg.toString()).collect(Collectors.joining(",")), this.currentRequest, context});
        }
    }

    public void channelActive(ChannelHandlerContext context) throws Exception {
        this.traceOperation(logger, this.context, "channelActive", new Object[0]);
        context.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext context) throws Exception {
        this.traceOperation(logger, this.context, "channelInactive", new Object[0]);
        Channel channel = context.channel();
        try {
            this.contextRequestFuture.getNow(null);
            this.contextFuture.getNow(null);
            logger.debug("{} INACTIVE: RNTBD negotiation request status:\nrequest: {}\nresponse: {}", new Object[]{channel, this.contextRequestFuture, this.contextFuture});
        }
        catch (CancellationException error) {
            logger.debug("{} INACTIVE: RNTBD negotiation request cancelled:", (Object)channel, (Object)error);
        }
        catch (Exception error) {
            logger.error("{} INACTIVE: RNTBD negotiation request failed:", (Object)channel, (Object)error);
        }
        if (!this.pendingWrites.isEmpty()) {
            this.pendingWrites.releaseAndFailAll((ChannelOutboundInvoker)context, (Throwable)new ChannelException("Closed with pending writes"));
        }
        if (!this.pendingRequests.isEmpty()) {
            String reason = String.format("%s Closed with pending requests", channel);
            ChannelException cause = new ChannelException(reason);
            for (PendingRequest pendingRequest : this.pendingRequests.values()) {
                pendingRequest.getResponseFuture().completeExceptionally((Throwable)cause);
            }
            this.pendingRequests.clear();
        }
        context.fireChannelInactive();
    }

    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        this.traceOperation(logger, context, "channelRead", new Object[0]);
        if (message instanceof RntbdResponse) {
            try {
                this.messageReceived(context, (RntbdResponse)message);
            }
            finally {
                ReferenceCountUtil.release((Object)message);
            }
            this.traceOperation(logger, context, "messageReceived", new Object[0]);
            return;
        }
        String reason = String.format("Expected message of type %s, not %s", RntbdResponse.class, message.getClass());
        throw new IllegalStateException(reason);
    }

    public void channelReadComplete(ChannelHandlerContext context) throws Exception {
        this.traceOperation(logger, context, "channelReadComplete", new Object[0]);
        context.fireChannelReadComplete();
    }

    public void channelRegistered(ChannelHandlerContext context) throws Exception {
        this.traceOperation(logger, context, "channelRegistered", new Object[0]);
        if (this.context != null || this.pendingWrites != null) {
            throw new IllegalStateException();
        }
        this.pendingWrites = new CoalescingBufferQueue(context.channel());
        this.context = context;
        context.fireChannelRegistered();
    }

    public void channelUnregistered(ChannelHandlerContext context) throws Exception {
        this.traceOperation(logger, context, "channelUnregistered", new Object[0]);
        if (this.context == null || this.pendingWrites == null || !this.pendingWrites.isEmpty()) {
            throw new IllegalStateException();
        }
        this.pendingWrites = null;
        this.context = null;
        context.fireChannelUnregistered();
    }

    public void channelWritabilityChanged(ChannelHandlerContext context) throws Exception {
        this.traceOperation(logger, context, "channelWritabilityChanged", new Object[0]);
        context.fireChannelWritabilityChanged();
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        logger.error("{} closing exceptionally: {}", (Object)context.channel(), (Object)cause.getMessage());
        this.traceOperation(logger, context, "exceptionCaught", cause);
        context.close();
    }

    public void handlerAdded(ChannelHandlerContext context) throws Exception {
        this.traceOperation(logger, context, "handlerAdded", new Object[0]);
    }

    public void handlerRemoved(ChannelHandlerContext context) throws Exception {
        this.traceOperation(logger, context, "handlerRemoved", new Object[0]);
    }

    public void userEventTriggered(ChannelHandlerContext context, Object event) throws Exception {
        this.traceOperation(logger, context, "userEventTriggered", event);
        if (event instanceof RntbdContext) {
            this.completeRntbdContextFuture(context, (RntbdContext)event);
            return;
        }
        context.fireUserEventTriggered(event);
    }

    public void bind(ChannelHandlerContext context, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.traceOperation(logger, context, "bind", new Object[0]);
        context.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext context, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.traceOperation(logger, context, "connect", new Object[0]);
        context.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext context, ChannelPromise promise) throws Exception {
        this.traceOperation(logger, context, "disconnect", new Object[0]);
        context.disconnect(promise);
    }

    public void close(ChannelHandlerContext context, ChannelPromise promise) throws Exception {
        this.traceOperation(logger, context, "close", new Object[0]);
        context.close(promise);
    }

    public void deregister(ChannelHandlerContext context, ChannelPromise promise) throws Exception {
        this.traceOperation(logger, context, "deregister", new Object[0]);
        context.deregister(promise);
    }

    public void flush(ChannelHandlerContext context) throws Exception {
        this.traceOperation(logger, context, "flush", new Object[0]);
        context.flush();
    }

    public void read(ChannelHandlerContext context) throws Exception {
        this.traceOperation(logger, context, "read", new Object[0]);
        context.read();
    }

    public void write(ChannelHandlerContext context, Object message, ChannelPromise promise) throws Exception {
        this.traceOperation(logger, context, "write", message);
        if (message instanceof RntbdRequestArgs) {
            this.currentRequest = this.getPendingRequest((RntbdRequestArgs)message);
            context.write(message, promise);
            return;
        }
        String reason = String.format("Expected message of type %s, not %s", RntbdRequestArgs.class, message.getClass());
        throw new IllegalStateException(reason);
    }

    CompletableFuture<RntbdContextRequest> getRntbdContextRequestFuture() {
        return this.contextRequestFuture;
    }

    boolean hasRntbdContext() {
        return this.contextFuture.getNow(null) != null;
    }

    void pendWrite(ByteBuf out, ChannelPromise promise) {
        Objects.requireNonNull(out, "out");
        if (this.pendingWrites == null) {
            throw new IllegalStateException("pendingWrites: null");
        }
        this.pendingWrites.add(out, promise);
    }

    private PendingRequest checkPendingRequest(UUID activityId, PendingRequest pendingRequest) {
        if (pendingRequest == null) {
            throw new IllegalStateException(String.format("Pending request not found: %s", activityId));
        }
        if (pendingRequest.getResponseFuture().isDone()) {
            throw new IllegalStateException(String.format("Request is not pending: %s", activityId));
        }
        return pendingRequest;
    }

    private void completeRntbdContextFuture(ChannelHandlerContext context, RntbdContext value) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(value, "value");
        if (this.contextFuture.isDone()) {
            throw new IllegalStateException(String.format("rntbdContextFuture: %s", this.contextFuture));
        }
        this.contextFuture.complete(value);
        RntbdContextNegotiator negotiator = (RntbdContextNegotiator)context.channel().pipeline().get(RntbdContextNegotiator.class);
        negotiator.removeInboundHandler();
        negotiator.removeOutboundHandler();
        if (!this.pendingWrites.isEmpty()) {
            this.pendingWrites.writeAndRemoveAll(context);
        }
    }

    private PendingRequest getPendingRequest(RntbdRequestArgs args) {
        UUID activityId = args.getActivityId();
        return this.checkPendingRequest(activityId, this.pendingRequests.get(activityId));
    }

    private Optional<RntbdContext> getRntbdContext() {
        return Optional.of(this.contextFuture.getNow(null));
    }

    private void messageReceived(ChannelHandlerContext context, RntbdResponse response) {
        UUID activityId = response.getActivityId();
        PendingRequest pendingRequest = this.pendingRequests.remove(activityId);
        if (pendingRequest == null) {
            logger.warn("[activityId: {}] no request pending", (Object)activityId);
            return;
        }
        CompletableFuture<StoreResponse> future = pendingRequest.getResponseFuture();
        HttpResponseStatus status = response.getStatus();
        if (HttpResponseStatus.OK.code() <= status.code() && status.code() < HttpResponseStatus.MULTIPLE_CHOICES.code()) {
            StoreResponse storeResponse = response.toStoreResponse(this.contextFuture.getNow(null));
            future.complete(storeResponse);
        } else {
            Object cause;
            Error error;
            String partitionKeyRangeId;
            long lsn;
            block41: {
                lsn = (Long)response.getHeader(RntbdConstants.RntbdResponseHeader.LSN);
                partitionKeyRangeId = (String)response.getHeader(RntbdConstants.RntbdResponseHeader.PartitionKeyRangeId);
                ObjectMapper mapper = new ObjectMapper();
                if (response.hasPayload()) {
                    try (InputStreamReader reader = response.getResponseStreamReader();){
                        error = BridgeInternal.createError((ObjectNode)((ObjectNode)mapper.readTree((Reader)reader)));
                        break block41;
                    }
                    catch (IOException e) {
                        String message = String.format("%s: %s", e.getClass(), e.getMessage());
                        logger.error("{} %s", (Object)context.channel(), (Object)message);
                        throw new CorruptedFrameException(message);
                    }
                }
                error = new Error(Integer.toString(status.code()), status.reasonPhrase(), status.codeClass().name());
            }
            Map<String, String> responseHeaders = response.getHeaders().asMap(this.getRntbdContext().orElseThrow(IllegalStateException::new), activityId);
            block5 : switch (status.code()) {
                case 400: {
                    cause = new BadRequestException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 409: {
                    cause = new ConflictException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 403: {
                    cause = new ForbiddenException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 410: {
                    int subStatusCode = Math.toIntExact((Long)response.getHeader(RntbdConstants.RntbdResponseHeader.SubStatus));
                    switch (subStatusCode) {
                        case 1007: {
                            cause = new PartitionKeyRangeIsSplittingException(error, lsn, partitionKeyRangeId, responseHeaders);
                            break block5;
                        }
                        case 1008: {
                            cause = new PartitionIsMigratingException(error, lsn, partitionKeyRangeId, responseHeaders);
                            break block5;
                        }
                        case 1000: {
                            cause = new InvalidPartitionException(error, lsn, partitionKeyRangeId, responseHeaders);
                            break block5;
                        }
                        case 1002: {
                            cause = new PartitionKeyRangeGoneException(error, lsn, partitionKeyRangeId, responseHeaders);
                            break block5;
                        }
                    }
                    cause = new GoneException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 500: {
                    cause = new InternalServerErrorException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 423: {
                    cause = new LockedException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 405: {
                    cause = new MethodNotAllowedException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 404: {
                    cause = new NotFoundException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 412: {
                    cause = new PreconditionFailedException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 413: {
                    cause = new RequestEntityTooLargeException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 408: {
                    cause = new RequestTimeoutException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 449: {
                    cause = new RetryWithException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 503: {
                    cause = new ServiceUnavailableException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 429: {
                    cause = new RequestRateTooLargeException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 401: {
                    cause = new UnauthorizedException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                default: {
                    cause = new DocumentClientException(status.code(), error, responseHeaders);
                }
            }
            logger.trace("{}[activityId: {}, statusCode: {}, subStatusCode: {}] {}", new Object[]{context.channel(), cause.getActivityId(), cause.getStatusCode(), cause.getSubStatusCode(), cause.getMessage()});
            future.completeExceptionally((Throwable)cause);
        }
    }

    private PendingRequest removePendingRequest(UUID activityId) {
        PendingRequest pendingRequest = this.pendingRequests.remove(activityId);
        return this.checkPendingRequest(activityId, pendingRequest);
    }

    private static class PendingRequest {
        private final RntbdRequestArgs args;
        private final CompletableFuture<StoreResponse> responseFuture = new CompletableFuture();

        PendingRequest(RntbdRequestArgs args) {
            this.args = args;
        }

        RntbdRequestArgs getArgs() {
            return this.args;
        }

        long getBirthTime() {
            return this.args.getBirthTime();
        }

        Duration getLifetime() {
            return this.args.getLifetime();
        }

        CompletableFuture<StoreResponse> getResponseFuture() {
            return this.responseFuture;
        }

        public String toString() {
            return this.args.toString();
        }
    }
}

