/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common.blockaliasmap.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMap;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryLevelDBAliasMapServer;
import org.apache.hadoop.hdfs.server.common.BlockAlias;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.impl.InMemoryLevelDBAliasMapClient;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Lists;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestInMemoryLevelDBAliasMapClient {
    private InMemoryLevelDBAliasMapServer levelDBAliasMapServer;
    private InMemoryLevelDBAliasMapClient inMemoryLevelDBAliasMapClient;
    private File tempDir;
    private Configuration conf;
    private static final String BPID = "BPID-0";
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws IOException {
        this.conf = new Configuration();
        int port = 9876;
        this.conf.set("dfs.provided.aliasmap.inmemory.dnrpc-address", "localhost:" + port);
        File testDir = GenericTestUtils.getTestDir();
        this.tempDir = Files.createTempDirectory(testDir.toPath(), "test", new FileAttribute[0]).toFile();
        File levelDBDir = new File(this.tempDir, BPID);
        levelDBDir.mkdirs();
        this.conf.set("dfs.provided.aliasmap.inmemory.leveldb.dir", this.tempDir.getAbsolutePath());
        this.levelDBAliasMapServer = new InMemoryLevelDBAliasMapServer(InMemoryAliasMap::init, BPID);
        this.inMemoryLevelDBAliasMapClient = new InMemoryLevelDBAliasMapClient();
    }

    @After
    public void tearDown() throws IOException {
        this.levelDBAliasMapServer.close();
        this.inMemoryLevelDBAliasMapClient.close();
        FileUtils.deleteDirectory((File)this.tempDir);
    }

    @Test
    public void writeRead() throws Exception {
        this.levelDBAliasMapServer.setConf(this.conf);
        this.levelDBAliasMapServer.start();
        this.inMemoryLevelDBAliasMapClient.setConf(this.conf);
        Block block = new Block(42L, 43L, 44L);
        byte[] nonce = "blackbird".getBytes();
        ProvidedStorageLocation providedStorageLocation = new ProvidedStorageLocation(new Path("cuckoo"), 45L, 46L, nonce);
        BlockAliasMap.Writer writer = this.inMemoryLevelDBAliasMapClient.getWriter(null, BPID);
        writer.store((BlockAlias)new FileRegion(block, providedStorageLocation));
        BlockAliasMap.Reader reader = this.inMemoryLevelDBAliasMapClient.getReader(null, BPID);
        Optional fileRegion = reader.resolve(block);
        Assert.assertEquals((Object)new FileRegion(block, providedStorageLocation), fileRegion.get());
    }

    @Test
    public void iterateSingleBatch() throws Exception {
        this.levelDBAliasMapServer.setConf(this.conf);
        this.levelDBAliasMapServer.start();
        this.inMemoryLevelDBAliasMapClient.setConf(this.conf);
        Block block1 = new Block(42L, 43L, 44L);
        Block block2 = new Block(43L, 44L, 45L);
        byte[] nonce1 = "blackbird".getBytes();
        byte[] nonce2 = "cuckoo".getBytes();
        ProvidedStorageLocation providedStorageLocation1 = new ProvidedStorageLocation(new Path("eagle"), 46L, 47L, nonce1);
        ProvidedStorageLocation providedStorageLocation2 = new ProvidedStorageLocation(new Path("falcon"), 46L, 47L, nonce2);
        BlockAliasMap.Writer writer1 = this.inMemoryLevelDBAliasMapClient.getWriter(null, BPID);
        writer1.store((BlockAlias)new FileRegion(block1, providedStorageLocation1));
        BlockAliasMap.Writer writer2 = this.inMemoryLevelDBAliasMapClient.getWriter(null, BPID);
        writer2.store((BlockAlias)new FileRegion(block2, providedStorageLocation2));
        BlockAliasMap.Reader reader = this.inMemoryLevelDBAliasMapClient.getReader(null, BPID);
        ArrayList actualFileRegions = Lists.newArrayListWithCapacity((int)2);
        for (FileRegion fileRegion : reader) {
            actualFileRegions.add(fileRegion);
        }
        Assert.assertArrayEquals((Object[])new FileRegion[]{new FileRegion(block1, providedStorageLocation1), new FileRegion(block2, providedStorageLocation2)}, (Object[])actualFileRegions.toArray());
    }

    @Test
    public void iterateThreeBatches() throws Exception {
        this.conf.set("dfs.provided.aliasmap.inmemory.batch-size", "2");
        this.levelDBAliasMapServer.setConf(this.conf);
        this.levelDBAliasMapServer.start();
        this.inMemoryLevelDBAliasMapClient.setConf(this.conf);
        Block block1 = new Block(42L, 43L, 44L);
        Block block2 = new Block(43L, 44L, 45L);
        Block block3 = new Block(44L, 45L, 46L);
        Block block4 = new Block(47L, 48L, 49L);
        Block block5 = new Block(50L, 51L, 52L);
        Block block6 = new Block(53L, 54L, 55L);
        byte[] nonce1 = "blackbird".getBytes();
        byte[] nonce2 = "cuckoo".getBytes();
        byte[] nonce3 = "sparrow".getBytes();
        byte[] nonce4 = "magpie".getBytes();
        byte[] nonce5 = "seagull".getBytes();
        byte[] nonce6 = "finch".getBytes();
        ProvidedStorageLocation providedStorageLocation1 = new ProvidedStorageLocation(new Path("eagle"), 46L, 47L, nonce1);
        ProvidedStorageLocation providedStorageLocation2 = new ProvidedStorageLocation(new Path("falcon"), 48L, 49L, nonce2);
        ProvidedStorageLocation providedStorageLocation3 = new ProvidedStorageLocation(new Path("robin"), 50L, 51L, nonce3);
        ProvidedStorageLocation providedStorageLocation4 = new ProvidedStorageLocation(new Path("parakeet"), 52L, 53L, nonce4);
        ProvidedStorageLocation providedStorageLocation5 = new ProvidedStorageLocation(new Path("heron"), 54L, 55L, nonce5);
        ProvidedStorageLocation providedStorageLocation6 = new ProvidedStorageLocation(new Path("duck"), 56L, 57L, nonce6);
        this.inMemoryLevelDBAliasMapClient.getWriter(null, BPID).store((BlockAlias)new FileRegion(block1, providedStorageLocation1));
        this.inMemoryLevelDBAliasMapClient.getWriter(null, BPID).store((BlockAlias)new FileRegion(block2, providedStorageLocation2));
        this.inMemoryLevelDBAliasMapClient.getWriter(null, BPID).store((BlockAlias)new FileRegion(block3, providedStorageLocation3));
        this.inMemoryLevelDBAliasMapClient.getWriter(null, BPID).store((BlockAlias)new FileRegion(block4, providedStorageLocation4));
        this.inMemoryLevelDBAliasMapClient.getWriter(null, BPID).store((BlockAlias)new FileRegion(block5, providedStorageLocation5));
        this.inMemoryLevelDBAliasMapClient.getWriter(null, BPID).store((BlockAlias)new FileRegion(block6, providedStorageLocation6));
        BlockAliasMap.Reader reader = this.inMemoryLevelDBAliasMapClient.getReader(null, BPID);
        ArrayList actualFileRegions = Lists.newArrayListWithCapacity((int)6);
        for (FileRegion fileRegion : reader) {
            actualFileRegions.add(fileRegion);
        }
        Object[] expectedFileRegions = new FileRegion[]{new FileRegion(block1, providedStorageLocation1), new FileRegion(block2, providedStorageLocation2), new FileRegion(block3, providedStorageLocation3), new FileRegion(block4, providedStorageLocation4), new FileRegion(block5, providedStorageLocation5), new FileRegion(block6, providedStorageLocation6)};
        Assert.assertArrayEquals((Object[])expectedFileRegions, (Object[])actualFileRegions.toArray());
    }

    public FileRegion generateRandomFileRegion(int seed) {
        Block block = new Block((long)seed, (long)(seed + 1), (long)(seed + 2));
        Path path = new Path("koekoek");
        byte[] nonce = new byte[]{};
        ProvidedStorageLocation providedStorageLocation = new ProvidedStorageLocation(path, (long)(seed + 3), (long)(seed + 4), nonce);
        return new FileRegion(block, providedStorageLocation);
    }

    @Test
    public void multipleReads() throws IOException {
        this.levelDBAliasMapServer.setConf(this.conf);
        this.levelDBAliasMapServer.start();
        this.inMemoryLevelDBAliasMapClient.setConf(this.conf);
        Random r = new Random();
        List<FileRegion> expectedFileRegions = r.ints(0, 200).limit(50L).boxed().map(i -> this.generateRandomFileRegion((int)i)).collect(Collectors.toList());
        BlockAliasMap.Reader reader = this.inMemoryLevelDBAliasMapClient.getReader(null, BPID);
        BlockAliasMap.Writer writer = this.inMemoryLevelDBAliasMapClient.getWriter(null, BPID);
        ExecutorService executor = Executors.newCachedThreadPool();
        List readThreads = expectedFileRegions.stream().map(fileRegion -> new ReadThread(fileRegion.getBlock(), (BlockAliasMap.Reader<FileRegion>)reader, 4000)).collect(Collectors.toList());
        List readFutures = readThreads.stream().map(readThread -> executor.submit((Runnable)readThread)).collect(Collectors.toList());
        List writeFutures = expectedFileRegions.stream().map(fileRegion -> new WriteThread(fileRegion.getBlock(), fileRegion.getProvidedStorageLocation(), (BlockAliasMap.Writer<FileRegion>)writer, 1000)).map(writeThread -> executor.submit((Runnable)writeThread)).collect(Collectors.toList());
        readFutures.stream().map(readFuture -> {
            try {
                return readFuture.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        List actualFileRegions = readThreads.stream().map(readThread -> readThread.getFileRegion().get()).collect(Collectors.toList());
        Assertions.assertThat(actualFileRegions).containsExactlyInAnyOrder((Object[])expectedFileRegions.toArray(new FileRegion[0]));
    }

    @Test
    public void testServerBindHost() throws Exception {
        this.conf.set("dfs.namenode.servicerpc-bind-host", "0.0.0.0");
        this.writeRead();
    }

    @Test
    public void testNonExistentBlock() throws Exception {
        this.inMemoryLevelDBAliasMapClient.setConf(this.conf);
        this.levelDBAliasMapServer.setConf(this.conf);
        this.levelDBAliasMapServer.start();
        Block block1 = new Block(100L, 43L, 44L);
        ProvidedStorageLocation providedStorageLocation1 = null;
        BlockAliasMap.Writer writer1 = this.inMemoryLevelDBAliasMapClient.getWriter(null, BPID);
        try {
            writer1.store((BlockAlias)new FileRegion(block1, providedStorageLocation1));
            Assert.fail((String)"Should fail on writing a region with null ProvidedLocation");
        }
        catch (IOException | IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("not be null"));
        }
        BlockAliasMap.Reader reader = this.inMemoryLevelDBAliasMapClient.getReader(null, BPID);
        LambdaTestUtils.assertOptionalUnset((String)"Expected empty BlockAlias", (Optional)reader.resolve(block1));
    }

    class WriteThread
    implements Runnable {
        private final Block block;
        private final BlockAliasMap.Writer<FileRegion> writer;
        private final ProvidedStorageLocation providedStorageLocation;
        private int delay;

        WriteThread(Block block, ProvidedStorageLocation providedStorageLocation, BlockAliasMap.Writer<FileRegion> writer, int delay) {
            this.block = block;
            this.writer = writer;
            this.providedStorageLocation = providedStorageLocation;
            this.delay = delay;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.delay);
                this.writer.store((BlockAlias)new FileRegion(this.block, this.providedStorageLocation));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    class ReadThread
    implements Runnable {
        private final Block block;
        private final BlockAliasMap.Reader<FileRegion> reader;
        private int delay;
        private Optional<FileRegion> fileRegionOpt;

        ReadThread(Block block, BlockAliasMap.Reader<FileRegion> reader, int delay) {
            this.block = block;
            this.reader = reader;
            this.delay = delay;
        }

        public Optional<FileRegion> getFileRegion() {
            return this.fileRegionOpt;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.delay);
                this.fileRegionOpt = this.reader.resolve(this.block);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

