/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.tools.DFSck;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestBlockInfoStriped {
    private static final long BASE_ID = -1600L;
    private final Block baseBlock = new Block(-1600L);
    private final ErasureCodingPolicy testECPolicy;
    private final int totalBlocks;
    private final BlockInfoStriped info;
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    public TestBlockInfoStriped(ErasureCodingPolicy policy) {
        this.testECPolicy = policy;
        this.totalBlocks = this.testECPolicy.getNumDataUnits() + this.testECPolicy.getNumParityUnits();
        this.info = new BlockInfoStriped(this.baseBlock, this.testECPolicy);
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> policies() {
        return StripedFileTestUtil.getECPolicies();
    }

    private Block[] createReportedBlocks(int num) {
        Block[] blocks = new Block[num];
        for (int i = 0; i < num; ++i) {
            blocks[i] = new Block(-1600L + (long)i);
        }
        return blocks;
    }

    @Test
    public void testAddStorage() {
        int index;
        int i;
        DatanodeStorageInfo[] storageInfos = DFSTestUtil.createDatanodeStorageInfos(this.totalBlocks);
        Block[] blocks = this.createReportedBlocks(this.totalBlocks);
        for (i = 0; i < storageInfos.length; i += 2) {
            this.info.addStorage(storageInfos[i], blocks[i]);
            Assert.assertEquals((long)(i / 2 + 1), (long)this.info.numNodes());
        }
        i /= 2;
        for (int j = 1; j < storageInfos.length; j += 2) {
            Assert.assertTrue((boolean)this.info.addStorage(storageInfos[j], blocks[j]));
            Assert.assertEquals((long)(i + (j + 1) / 2), (long)this.info.numNodes());
        }
        byte[] indices = (byte[])Whitebox.getInternalState((Object)this.info, (String)"indices");
        Assert.assertEquals((long)this.totalBlocks, (long)this.info.getCapacity());
        Assert.assertEquals((long)this.totalBlocks, (long)indices.length);
        i = 0;
        for (DatanodeStorageInfo storage : storageInfos) {
            index = this.info.findStorageInfo(storage);
            Assert.assertEquals((long)i++, (long)index);
            Assert.assertEquals((long)index, (long)indices[index]);
        }
        i = 0;
        for (DatanodeStorageInfo storage : storageInfos) {
            Assert.assertTrue((boolean)this.info.addStorage(storage, blocks[i++]));
        }
        Assert.assertEquals((long)this.totalBlocks, (long)this.info.getCapacity());
        Assert.assertEquals((long)this.totalBlocks, (long)this.info.numNodes());
        Assert.assertEquals((long)this.totalBlocks, (long)indices.length);
        i = 0;
        for (DatanodeStorageInfo storage : storageInfos) {
            index = this.info.findStorageInfo(storage);
            Assert.assertEquals((long)i++, (long)index);
            Assert.assertEquals((long)index, (long)indices[index]);
        }
        DatanodeStorageInfo[] storageInfos2 = DFSTestUtil.createDatanodeStorageInfos(this.totalBlocks * 2);
        for (i = this.totalBlocks; i < storageInfos2.length; ++i) {
            this.info.addStorage(storageInfos2[i], blocks[i % this.totalBlocks]);
            Assert.assertEquals((long)(i + 1), (long)this.info.getCapacity());
            Assert.assertEquals((long)(i + 1), (long)this.info.numNodes());
            indices = (byte[])Whitebox.getInternalState((Object)this.info, (String)"indices");
            Assert.assertEquals((long)(i + 1), (long)indices.length);
        }
        for (i = this.totalBlocks; i < storageInfos2.length; ++i) {
            int index2 = this.info.findStorageInfo(storageInfos2[i]);
            Assert.assertEquals((long)i++, (long)index2);
            Assert.assertEquals((long)(index2 - this.totalBlocks), (long)indices[index2]);
        }
    }

    @Test
    public void testRemoveStorage() {
        int index;
        int i;
        DatanodeStorageInfo[] storages = DFSTestUtil.createDatanodeStorageInfos(this.totalBlocks);
        Block[] blocks = this.createReportedBlocks(this.totalBlocks);
        for (int i2 = 0; i2 < storages.length; ++i2) {
            this.info.addStorage(storages[i2], blocks[i2]);
        }
        this.info.removeStorage(storages[0]);
        this.info.removeStorage(storages[2]);
        Assert.assertEquals((long)this.totalBlocks, (long)this.info.getCapacity());
        Assert.assertEquals((long)(this.totalBlocks - 2), (long)this.info.numNodes());
        byte[] indices = (byte[])Whitebox.getInternalState((Object)this.info, (String)"indices");
        for (int i3 = 0; i3 < storages.length; ++i3) {
            int index2 = this.info.findStorageInfo(storages[i3]);
            if (i3 != 0 && i3 != 2) {
                Assert.assertEquals((long)i3, (long)index2);
                Assert.assertEquals((long)index2, (long)indices[index2]);
                continue;
            }
            Assert.assertEquals((long)-1L, (long)index2);
            Assert.assertEquals((long)-1L, (long)indices[i3]);
        }
        DatanodeStorageInfo[] storages2 = DFSTestUtil.createDatanodeStorageInfos(this.totalBlocks * 2);
        for (int i4 = this.totalBlocks; i4 < storages2.length; ++i4) {
            this.info.addStorage(storages2[i4], blocks[i4 % this.totalBlocks]);
        }
        Assert.assertEquals((long)(this.totalBlocks * 2 - 2), (long)this.info.numNodes());
        Assert.assertEquals((long)(this.totalBlocks * 2 - 2), (long)this.info.getCapacity());
        indices = (byte[])Whitebox.getInternalState((Object)this.info, (String)"indices");
        Assert.assertEquals((long)(this.totalBlocks * 2 - 2), (long)indices.length);
        int j = this.totalBlocks;
        for (i = this.totalBlocks; i < storages2.length; ++i) {
            index = this.info.findStorageInfo(storages2[i]);
            if (i == this.totalBlocks || i == this.totalBlocks + 2) {
                Assert.assertEquals((long)(i - this.totalBlocks), (long)index);
                continue;
            }
            Assert.assertEquals((long)j++, (long)index);
        }
        for (i = 0; i < this.totalBlocks; ++i) {
            this.info.removeStorage(storages2[i + this.totalBlocks]);
        }
        Assert.assertEquals((long)(this.totalBlocks - 2), (long)this.info.numNodes());
        Assert.assertEquals((long)(this.totalBlocks * 2 - 2), (long)this.info.getCapacity());
        indices = (byte[])Whitebox.getInternalState((Object)this.info, (String)"indices");
        Assert.assertEquals((long)(this.totalBlocks * 2 - 2), (long)indices.length);
        for (i = 0; i < this.totalBlocks; ++i) {
            if (i == 0 || i == 2) {
                index = this.info.findStorageInfo(storages2[i + this.totalBlocks]);
                Assert.assertEquals((long)-1L, (long)index);
                continue;
            }
            index = this.info.findStorageInfo(storages[i]);
            Assert.assertEquals((long)i, (long)index);
        }
        for (i = this.totalBlocks; i < this.totalBlocks * 2 - 2; ++i) {
            Assert.assertEquals((long)-1L, (long)indices[i]);
            Assert.assertNull((Object)this.info.getDatanode(i));
        }
    }

    @Test
    public void testGetBlockInfo() throws IllegalArgumentException, Exception {
        int dataBlocks = this.testECPolicy.getNumDataUnits();
        int parityBlocks = this.testECPolicy.getNumParityUnits();
        int totalSize = dataBlocks + parityBlocks;
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        Configuration conf = new Configuration();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf, builderBaseDir).numDataNodes(totalSize).build();){
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            fs.enableErasureCodingPolicy(this.testECPolicy.getName());
            fs.mkdirs(new Path("/ecDir"));
            fs.setErasureCodingPolicy(new Path("/ecDir"), this.testECPolicy.getName());
            DFSTestUtil.createFile((FileSystem)fs, new Path("/ecDir/ecFile"), fs.getDefaultBlockSize() * (long)dataBlocks, (short)1, 1024L);
            ExtendedBlock blk = DFSTestUtil.getAllBlocks((FileSystem)fs, new Path("/ecDir/ecFile")).get(0).getBlock();
            String id = "blk_" + Long.toString(blk.getBlockId());
            BlockInfo bInfo = cluster.getNameNode().getNamesystem().getBlockManager().getStoredBlock(blk.getLocalBlock());
            DatanodeStorageInfo[] dnStorageInfo = cluster.getNameNode().getNamesystem().getBlockManager().getStorages(bInfo);
            bInfo.removeStorage(dnStorageInfo[1]);
            ByteArrayOutputStream bStream = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(bStream, true);
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)new DFSck(conf, out), (String[])new String[]{new Path("/ecDir/ecFile").toString(), "-blockId", id}));
            Assert.assertFalse((boolean)out.toString().contains("null"));
        }
    }

    @Test
    public void testWrite() {
        long blkID = 1L;
        long numBytes = 1L;
        long generationStamp = 1L;
        ByteBuffer byteBuffer = ByteBuffer.allocate(24);
        byteBuffer.putLong(blkID).putLong(numBytes).putLong(generationStamp);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        BlockInfoStriped blk = new BlockInfoStriped(new Block(blkID, numBytes, generationStamp), this.testECPolicy);
        try {
            blk.write((DataOutput)out);
        }
        catch (Exception ex) {
            Assert.fail((String)("testWrite error:" + ex.getMessage()));
        }
        Assert.assertEquals((long)byteBuffer.array().length, (long)byteStream.toByteArray().length);
        Assert.assertArrayEquals((byte[])byteBuffer.array(), (byte[])byteStream.toByteArray());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddStorageWithReplicatedBlock() {
        DatanodeStorageInfo storage = DFSTestUtil.createDatanodeStorageInfo("storageID", "127.0.0.1");
        BlockInfoContiguous replica = new BlockInfoContiguous(new Block(1000L), 3);
        this.info.addStorage(storage, (Block)replica);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddStorageWithDifferentBlockGroup() {
        DatanodeStorageInfo storage = DFSTestUtil.createDatanodeStorageInfo("storageID", "127.0.0.1");
        BlockInfoStriped diffGroup = new BlockInfoStriped(new Block(-1500L), this.testECPolicy);
        this.info.addStorage(storage, (Block)diffGroup);
    }
}

