/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSStripedOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DataStreamer;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedDataStreamer;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.SecurityTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.io.erasurecode.ErasureCodeNative;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestDFSStripedOutputStreamWithFailureBase {
    public static final Logger LOG = LoggerFactory.getLogger(TestDFSStripedOutputStreamWithFailureBase.class);
    protected final int cellSize = 65536;
    protected final int stripesPerBlock = 4;
    protected ErasureCodingPolicy ecPolicy;
    protected int dataBlocks;
    protected int parityBlocks;
    protected int blockSize;
    protected int blockGroupSize;
    private int[][] dnIndexSuite;
    protected List<Integer> lengths;
    protected static final Random RANDOM;
    MiniDFSCluster cluster;
    DistributedFileSystem dfs;
    final Path dir = new Path("/" + TestDFSStripedOutputStreamWithFailureBase.class.getSimpleName());
    protected static final int FLUSH_POS = 4609;

    public ECSchema getEcSchema() {
        return StripedFileTestUtil.getDefaultECPolicy().getSchema();
    }

    @Before
    public void init() {
        this.ecPolicy = new ErasureCodingPolicy(this.getEcSchema(), 65536);
        this.dataBlocks = this.ecPolicy.getNumDataUnits();
        this.parityBlocks = this.ecPolicy.getNumParityUnits();
        this.blockSize = 262144;
        this.blockGroupSize = this.blockSize * this.dataBlocks;
        this.dnIndexSuite = this.getDnIndexSuite();
        this.lengths = this.newLengths();
    }

    List<Integer> newLengths() {
        ArrayList<Integer> lens = new ArrayList<Integer>();
        lens.add(4611);
        for (int b = 0; b <= 2; ++b) {
            for (int c = 0; c < 4 * this.dataBlocks; ++c) {
                for (int delta = -1; delta <= 1; ++delta) {
                    int length = b * this.blockGroupSize + c * 65536 + delta;
                    System.out.println(lens.size() + ": length=" + length + ", (b, c, d) = (" + b + ", " + c + ", " + delta + ")");
                    lens.add(length);
                }
            }
        }
        return lens;
    }

    private int[][] getDnIndexSuite() {
        int maxNumLevel = 2;
        int maxPerLevel = 5;
        ArrayList<List<Integer>> allLists = new ArrayList<List<Integer>>();
        int numIndex = this.parityBlocks;
        for (int i = 0; i < 2 && numIndex > 1; --numIndex, ++i) {
            List<List<Integer>> lists = TestDFSStripedOutputStreamWithFailureBase.combinations(this.dataBlocks + this.parityBlocks, numIndex);
            if (lists.size() > 5) {
                Collections.shuffle(lists);
                lists = lists.subList(0, 5);
            }
            allLists.addAll(lists);
        }
        int[][] dnIndexArray = new int[allLists.size()][];
        for (int i = 0; i < dnIndexArray.length; ++i) {
            int[] list = new int[((List)allLists.get(i)).size()];
            for (int j = 0; j < list.length; ++j) {
                list[j] = (Integer)((List)allLists.get(i)).get(j);
            }
            dnIndexArray[i] = list;
        }
        return dnIndexArray;
    }

    private static List<List<Integer>> combinations(int n, int k) {
        LinkedList<List<Integer>> res = new LinkedList<List<Integer>>();
        if (k >= 1 && n >= k) {
            TestDFSStripedOutputStreamWithFailureBase.getComb(n, k, new Stack<Integer>(), res);
        }
        return res;
    }

    private static void getComb(int n, int k, Stack<Integer> stack, List<List<Integer>> res) {
        if (stack.size() == k) {
            ArrayList<Integer> list = new ArrayList<Integer>(stack);
            res.add(list);
        } else {
            int next;
            int n2 = next = stack.empty() ? 0 : stack.peek() + 1;
            while (next < n) {
                stack.push(next);
                TestDFSStripedOutputStreamWithFailureBase.getComb(n, k, stack, res);
                ++next;
            }
        }
        if (!stack.empty()) {
            stack.pop();
        }
    }

    int[] getKillPositions(int fileLen, int num) {
        int[] positions = new int[num];
        for (int i = 0; i < num; ++i) {
            positions[i] = fileLen * (i + 1) / (num + 1);
        }
        return positions;
    }

    Integer getLength(int i) {
        return i >= 0 && i < this.lengths.size() ? this.lengths.get(i) : null;
    }

    void setup(Configuration conf) throws IOException {
        System.out.println("NUM_DATA_BLOCKS  = " + this.dataBlocks);
        System.out.println("NUM_PARITY_BLOCKS= " + this.parityBlocks);
        System.out.println("CELL_SIZE        = 65536 (=" + StringUtils.TraditionalBinaryPrefix.long2String((long)65536L, (String)"B", (int)2) + ")");
        System.out.println("BLOCK_SIZE       = " + this.blockSize + " (=" + StringUtils.TraditionalBinaryPrefix.long2String((long)this.blockSize, (String)"B", (int)2) + ")");
        System.out.println("BLOCK_GROUP_SIZE = " + this.blockGroupSize + " (=" + StringUtils.TraditionalBinaryPrefix.long2String((long)this.blockGroupSize, (String)"B", (int)2) + ")");
        int numDNs = this.dataBlocks + this.parityBlocks;
        if (ErasureCodeNative.isNativeCodeLoaded()) {
            conf.set("io.erasurecode.codec.rs.rawcoders", "rs_native");
        }
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDNs).build();
        this.cluster.waitActive();
        this.dfs = this.cluster.getFileSystem();
        AddErasureCodingPolicyResponse[] res = this.dfs.addErasureCodingPolicies(new ErasureCodingPolicy[]{this.ecPolicy});
        this.ecPolicy = res[0].getPolicy();
        this.dfs.enableErasureCodingPolicy(this.ecPolicy.getName());
        DFSTestUtil.enableAllECPolicies(this.dfs);
        this.dfs.mkdirs(this.dir);
        this.dfs.setErasureCodingPolicy(this.dir, this.ecPolicy.getName());
    }

    void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    HdfsConfiguration newHdfsConfiguration() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        conf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.replication.max-streams", 0);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTest(int length) {
        HdfsConfiguration conf = this.newHdfsConfiguration();
        for (int dn = 0; dn < this.dataBlocks + this.parityBlocks; ++dn) {
            try {
                LOG.info("runTest: dn=" + dn + ", length=" + length);
                this.setup((Configuration)conf);
                this.runTest(length, new int[]{length / 2}, new int[]{dn}, false);
                continue;
            }
            catch (Throwable e) {
                String err = "failed, dn=" + dn + ", length=" + length + StringUtils.stringifyException((Throwable)e);
                LOG.error(err);
                Assert.fail((String)err);
                continue;
            }
            finally {
                this.tearDown();
            }
        }
    }

    void runTestWithMultipleFailure(int length) throws Exception {
        HdfsConfiguration conf = this.newHdfsConfiguration();
        for (int[] dnIndex : this.dnIndexSuite) {
            int[] killPos = this.getKillPositions(length, dnIndex.length);
            try {
                LOG.info("runTestWithMultipleFailure: length==" + length + ", killPos=" + Arrays.toString(killPos) + ", dnIndex=" + Arrays.toString(dnIndex));
                this.setup((Configuration)conf);
                this.runTest(length, killPos, dnIndex, false);
            }
            catch (Throwable e) {
                String err = "failed, killPos=" + Arrays.toString(killPos) + ", dnIndex=" + Arrays.toString(dnIndex) + ", length=" + length;
                LOG.error(err);
                throw e;
            }
            finally {
                this.tearDown();
            }
        }
    }

    void runTest(int length, int[] killPos, int[] dnIndex, boolean tokenExpire) throws Exception {
        if (killPos[0] <= 4609) {
            LOG.warn("killPos=" + Arrays.toString(killPos) + " <= FLUSH_POS=" + 4609 + ", length=" + length + ", dnIndex=" + Arrays.toString(dnIndex));
            return;
        }
        Preconditions.checkArgument((length > killPos[0] ? 1 : 0) != 0, (String)"length=%s <= killPos=%s", (Object[])new Object[]{length, killPos});
        Preconditions.checkArgument((killPos.length == dnIndex.length ? 1 : 0) != 0);
        Path p = new Path(this.dir, "dn" + Arrays.toString(dnIndex) + "len" + length + "kill" + Arrays.toString(killPos));
        String fullPath = p.toString();
        LOG.info("fullPath=" + fullPath);
        if (tokenExpire) {
            NameNode nn = this.cluster.getNameNode();
            BlockManager bm = nn.getNamesystem().getBlockManager();
            BlockTokenSecretManager sm = bm.getBlockTokenSecretManager();
            SecurityTestUtil.setBlockTokenLifetime(sm, 6000L);
        }
        AtomicInteger pos = new AtomicInteger();
        FSDataOutputStream out = this.dfs.create(p);
        DFSStripedOutputStream stripedOut = (DFSStripedOutputStream)out.getWrappedStream();
        long firstGS = -1L;
        long oldGS = -1L;
        ArrayList<Long> gsList = new ArrayList<Long>();
        ArrayList<DatanodeInfo> killedDN = new ArrayList<DatanodeInfo>();
        int numKilled = 0;
        while (pos.get() < length) {
            int i = pos.getAndIncrement();
            if (numKilled < killPos.length && i == killPos[numKilled]) {
                Assert.assertTrue((firstGS != -1L ? 1 : 0) != 0);
                long gs = TestDFSStripedOutputStreamWithFailureBase.getGenerationStamp(stripedOut);
                if (numKilled == 0) {
                    Assert.assertEquals((long)firstGS, (long)gs);
                } else {
                    Assert.assertTrue((gs >= oldGS ? 1 : 0) != 0);
                }
                oldGS = gs;
                if (tokenExpire) {
                    DFSTestUtil.flushInternal(stripedOut);
                    this.waitTokenExpires(out);
                }
                killedDN.add(TestDFSStripedOutputStreamWithFailureBase.killDatanode(this.cluster, stripedOut, dnIndex[numKilled], pos));
                ++numKilled;
            }
            TestDFSStripedOutputStreamWithFailureBase.write(out, i);
            if (i % this.blockGroupSize == 4609) {
                oldGS = firstGS = TestDFSStripedOutputStreamWithFailureBase.getGenerationStamp(stripedOut);
            }
            if (i <= 0 || (i + 1) % this.blockGroupSize != 0) continue;
            gsList.add(oldGS);
        }
        gsList.add(oldGS);
        out.close();
        Assert.assertEquals((long)dnIndex.length, (long)numKilled);
        StripedFileTestUtil.waitBlockGroupsReported(this.dfs, fullPath, numKilled);
        this.cluster.triggerBlockReports();
        StripedFileTestUtil.checkData(this.dfs, p, length, killedDN, gsList, this.blockGroupSize);
    }

    static void write(FSDataOutputStream out, int i) throws IOException {
        try {
            out.write((int)StripedFileTestUtil.getByte(i));
        }
        catch (IOException ioe) {
            throw new IOException("Failed at i=" + i, ioe);
        }
    }

    static long getGenerationStamp(DFSStripedOutputStream out) throws IOException {
        long gs = out.getBlock().getGenerationStamp();
        LOG.info("getGenerationStamp returns " + gs);
        return gs;
    }

    static DatanodeInfo getDatanodes(StripedDataStreamer streamer) {
        while (true) {
            LocatedBlock lb;
            DatanodeInfo[] datanodes;
            if ((datanodes = streamer.getNodes()) == null && (lb = streamer.peekFollowingBlock()) != null) {
                datanodes = lb.getLocations();
            }
            if (datanodes != null) {
                Assert.assertEquals((long)1L, (long)datanodes.length);
                Assert.assertNotNull((Object)datanodes[0]);
                return datanodes[0];
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                Assert.fail((String)StringUtils.stringifyException((Throwable)ie));
                return null;
            }
        }
    }

    static DatanodeInfo killDatanode(MiniDFSCluster cluster, DFSStripedOutputStream out, int dnIndex, AtomicInteger pos) {
        StripedDataStreamer s = out.getStripedDataStreamer(dnIndex);
        DatanodeInfo datanode = TestDFSStripedOutputStreamWithFailureBase.getDatanodes(s);
        LOG.info("killDatanode " + dnIndex + ": " + datanode + ", pos=" + pos);
        if (datanode != null) {
            cluster.stopDataNode(datanode.getXferAddr());
        }
        return datanode;
    }

    private void waitTokenExpires(FSDataOutputStream out) throws IOException {
        Token<BlockTokenIdentifier> token = DFSTestUtil.getBlockToken(out);
        while (!SecurityTestUtil.isBlockTokenExpired(token)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static {
        GenericTestUtils.setLogLevel((Logger)DFSOutputStream.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)DataStreamer.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger(BlockPlacementPolicy.class), (Level)Level.TRACE);
        RANDOM = new Random();
    }
}

