/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.tools;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.impl.NetworkBinding;
import org.apache.hadoop.fs.s3a.impl.S3ExpressStorage;
import org.apache.hadoop.fs.s3a.s3guard.S3GuardTool;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.ExitUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.BucketInfo;
import software.amazon.awssdk.services.s3.model.BucketType;
import software.amazon.awssdk.services.s3.model.CreateBucketConfiguration;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DataRedundancy;
import software.amazon.awssdk.services.s3.model.LocationInfo;
import software.amazon.awssdk.services.s3.model.LocationType;

public final class BucketTool
extends S3GuardTool {
    private static final Logger LOG = LoggerFactory.getLogger(BucketTool.class);
    public static final String NAME = "bucket";
    public static final String PURPOSE = "View and manipulate S3 buckets";
    public static final String CREATE = "create";
    public static final String OPT_REGION = "region";
    public static final String OPT_ENDPOINT = "endpoint";
    public static final String OPT_ZONE = "zone";
    static final String UNSUPPORTED_ZONE_ARG = "The -zone option is only supported for Amazon S3 Express One Zone Storage";
    static final String NO_ZONE_SUPPLIED = "Required option -zone missing for Amazon S3 Express One Zone Storage bucket";
    public static final String PROBE_FAILURE = "Initialization failed because the bucket existence probefs.s3a.bucket.probe was not disabled. Check core-site settings.";

    public BucketTool(Configuration conf) {
        super(conf, 1, 1, CREATE);
        CommandFormat format = this.getCommandFormat();
        format.addOptionWithValue(OPT_REGION);
        format.addOptionWithValue(OPT_ENDPOINT);
        format.addOptionWithValue(OPT_ZONE);
    }

    @Override
    public String getUsage() {
        return "bucket -create [-endpoint <endpoint>] [-region <region>] [-zone <zone>]  <s3a-URL>";
    }

    @Override
    public String getName() {
        return NAME;
    }

    private Optional<String> getOptionalString(String key) {
        String value = this.getCommandFormat().getOptValue(key);
        return StringUtils.isNotEmpty((CharSequence)value) ? Optional.of(value) : Optional.empty();
    }

    @VisibleForTesting
    int exec(String ... args) throws Exception {
        return this.run(args, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] args, PrintStream out) throws Exception, ExitUtil.ExitException {
        S3AFileSystem fs;
        LOG.debug("Supplied arguments: {}", (Object)String.join((CharSequence)", ", args));
        List<String> parsedArgs = this.parseArgsWithErrorReporting(args);
        CommandFormat command = this.getCommandFormat();
        boolean create = command.getOpt(CREATE);
        Optional<String> endpoint = this.getOptionalString(OPT_ENDPOINT);
        Optional<String> region = this.getOptionalString(OPT_REGION);
        Optional<String> zone = this.getOptionalString(OPT_ZONE);
        String bucketPath = parsedArgs.get(0);
        Path source = new Path(bucketPath);
        URI fsURI = source.toUri();
        String bucket = fsURI.getHost();
        BucketTool.println(out, "Filesystem %s", fsURI);
        if (!"s3a".equals(fsURI.getScheme())) {
            throw new ExitUtil.ExitException(42, "Filesystem is not S3A URL: " + fsURI);
        }
        BucketTool.println(out, "Options region=%s endpoint=%s zone=%s s3a://%s", region.orElse("(unset)"), endpoint.orElse("(unset)"), zone.orElse("(unset)"), bucket);
        if (!create) {
            BucketTool.errorln(this.getUsage());
            BucketTool.println(out, "Supplied arguments: [" + String.join((CharSequence)", ", parsedArgs) + "]", new Object[0]);
            throw new ExitUtil.ExitException(42, "required option not found: -create");
        }
        Configuration conf = this.getConf();
        BucketTool.removeBucketOverrides(bucket, conf, "fs.s3a.bucket.probe", "fs.s3a.audit.reject.out.of.span.operations", "fs.s3a.endpoint.region", "fs.s3a.endpoint");
        String bucketPrefix = "fs.s3a.bucket." + bucket + '.';
        conf.setInt(bucketPrefix + "fs.s3a.bucket.probe", 0);
        conf.setBoolean(bucketPrefix + "fs.s3a.audit.reject.out.of.span.operations", false);
        BiFunction<String, Optional, Boolean> propagate = (key, opt) -> opt.map(v -> {
            conf.set(key, v);
            LOG.info("{} = {}", key, v);
            return true;
        }).orElse(false);
        propagate.apply("fs.s3a.endpoint.region", region);
        propagate.apply("fs.s3a.endpoint", endpoint);
        if (S3ExpressStorage.hasS3ExpressSuffix(bucket) && !NetworkBinding.isAwsEndpoint(endpoint.orElse(""))) {
            throw new ExitUtil.ExitException(46, UNSUPPORTED_ZONE_ARG);
        }
        try {
            fs = (S3AFileSystem)FileSystem.newInstance((URI)fsURI, (Configuration)conf);
        }
        catch (FileNotFoundException e) {
            BucketTool.errorln(PROBE_FAILURE);
            throw new ExitUtil.ExitException(49, PROBE_FAILURE);
        }
        try {
            CreateBucketConfiguration.Builder builder = CreateBucketConfiguration.builder();
            if (fs.hasPathCapability(new Path("/"), "fs.s3a.capability.s3express.storage")) {
                String az = zone.orElseThrow(() -> new ExitUtil.ExitException(42, NO_ZONE_SUPPLIED + bucket));
                builder.location((LocationInfo)LocationInfo.builder().type(LocationType.AVAILABILITY_ZONE).name(az).build()).bucket((BucketInfo)BucketInfo.builder().type(BucketType.DIRECTORY).dataRedundancy(DataRedundancy.SINGLE_AVAILABILITY_ZONE).build());
            } else {
                if (zone.isPresent()) {
                    throw new ExitUtil.ExitException(42, "The -zone option is only supported for Amazon S3 Express One Zone Storage not " + bucket);
                }
                region.ifPresent(arg_0 -> ((CreateBucketConfiguration.Builder)builder).locationConstraint(arg_0));
            }
            CreateBucketRequest request = (CreateBucketRequest)CreateBucketRequest.builder().bucket(bucket).createBucketConfiguration((CreateBucketConfiguration)builder.build()).build();
            BucketTool.println(out, "Creating bucket %s", bucket);
            S3Client s3Client = fs.getS3AInternals().getAmazonS3Client(NAME);
            try (DurationInfo ignored = new DurationInfo(LOG, "Create %sbucket %s in region %s", new Object[]{fs.hasPathCapability(new Path("/"), "fs.s3a.capability.s3express.storage") ? "Amazon S3 Express One Zone Storage " : "", bucket, region.orElse("(unset)")});){
                Invoker.once(CREATE, source.toString(), () -> s3Client.createBucket(request));
            }
        }
        finally {
            IOUtils.closeStream((Closeable)((Object)fs));
        }
        return 0;
    }

    public static void removeBucketOverrides(String bucket, Configuration conf, String ... options) {
        if (StringUtils.isEmpty((CharSequence)bucket)) {
            return;
        }
        String bucketPrefix = "fs.s3a.bucket." + bucket + '.';
        for (String option : options) {
            String extended;
            String stripped = option.substring("fs.s3a.".length());
            String target = bucketPrefix + stripped;
            String v = conf.get(target);
            if (v != null) {
                conf.unset(target);
            }
            if (conf.get(extended = bucketPrefix + option) == null) continue;
            conf.unset(extended);
        }
    }
}

