/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.prefetch;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.impl.prefetch.Validate;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.prefetch.S3ARemoteObject;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

public class S3ARemoteObjectReader
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(S3ARemoteObjectReader.class);
    private static final int READ_BUFFER_SIZE = 65536;
    private final S3ARemoteObject remoteObject;
    private volatile boolean closed;
    private final S3AInputStreamStatistics streamStatistics;

    public S3ARemoteObjectReader(S3ARemoteObject remoteObject) {
        Validate.checkNotNull((Object)remoteObject, (String)"remoteObject");
        this.remoteObject = remoteObject;
        this.streamStatistics = this.remoteObject.getStatistics();
    }

    public int read(ByteBuffer buffer, long offset, int size) throws IOException {
        Validate.checkNotNull((Object)buffer, (String)"buffer");
        Validate.checkWithinRange((long)offset, (String)"offset", (long)0L, (long)this.remoteObject.size());
        Validate.checkPositiveInteger((long)size, (String)"size");
        if (this.closed) {
            return -1;
        }
        int reqSize = (int)Math.min((long)size, this.remoteObject.size() - offset);
        return this.readOneBlockWithRetries(buffer, offset, reqSize);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private int readOneBlockWithRetries(ByteBuffer buffer, long offset, int size) throws IOException {
        this.streamStatistics.readOperationStarted(offset, size);
        Invoker invoker = this.remoteObject.getReadInvoker();
        int invokerResponse = (Integer)invoker.retry("read", this.remoteObject.getPath(), true, IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)this.streamStatistics, (String)"stream_read_block_read", () -> {
            try {
                this.readOneBlock(buffer, offset, size);
            }
            catch (EOFException e) {
                return -1;
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (IOException e) {
                this.remoteObject.getStatistics().readException();
                throw e;
            }
            return 0;
        }));
        int numBytesRead = buffer.position();
        buffer.limit(numBytesRead);
        this.remoteObject.getStatistics().readOperationCompleted(size, numBytesRead);
        if (invokerResponse < 0) {
            return invokerResponse;
        }
        return numBytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readOneBlock(ByteBuffer buffer, long offset, int size) throws IOException {
        int readSize = Math.min(size, buffer.remaining());
        if (readSize == 0) {
            return;
        }
        ResponseInputStream<GetObjectResponse> inputStream = this.remoteObject.openForRead(offset, readSize);
        int numRemainingBytes = readSize;
        byte[] bytes = new byte[65536];
        try {
            do {
                int numBytesToRead;
                int numBytes;
                if ((numBytes = inputStream.read(bytes, 0, numBytesToRead = Math.min(65536, numRemainingBytes))) < 0) {
                    String message = String.format("Unexpected end of stream: buffer[%d], readSize = %d, numRemainingBytes = %d", buffer.capacity(), readSize, numRemainingBytes);
                    throw new EOFException(message);
                }
                if (numBytes <= 0) continue;
                buffer.put(bytes, 0, numBytes);
                numRemainingBytes -= numBytes;
            } while (!this.closed && numRemainingBytes > 0);
        }
        finally {
            this.remoteObject.close(inputStream, numRemainingBytes);
        }
    }
}

