/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.staging;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathExistsException;
import org.apache.hadoop.fs.s3a.commit.AbstractS3ACommitter;
import org.apache.hadoop.fs.s3a.commit.impl.CommitContext;
import org.apache.hadoop.fs.s3a.commit.staging.ConflictResolution;
import org.apache.hadoop.fs.s3a.commit.staging.StagingCommitter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryStagingCommitter
extends StagingCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryStagingCommitter.class);
    public static final String NAME = "directory";

    public DirectoryStagingCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setupJob(JobContext context) throws IOException {
        Path outputPath = this.getOutputPath();
        FileSystem fs = this.getDestFS();
        ConflictResolution conflictResolution = this.getConflictResolutionMode(context, fs.getConf());
        LOG.info("Conflict Resolution mode is {}", (Object)conflictResolution);
        try {
            FileStatus status = fs.getFileStatus(outputPath);
            if (!status.isDirectory()) {
                throw new PathExistsException(outputPath.toString(), "output path is not a directory: Destination path exists and committer conflict resolution mode is \"fail\"");
            }
            switch (conflictResolution) {
                case FAIL: {
                    throw this.failDestinationExists(outputPath, "Setting job as " + this.getRole());
                }
                case APPEND: 
                case REPLACE: {
                    LOG.debug("Destination directory exists; conflict policy permits this");
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        super.setupJob(context);
    }

    @Override
    public void preCommitJob(CommitContext commitContext, AbstractS3ACommitter.ActiveCommit pending) throws IOException {
        JobContext context = commitContext.getJobContext();
        super.preCommitJob(commitContext, pending);
        Path outputPath = this.getOutputPath();
        FileSystem fs = this.getDestFS();
        Configuration fsConf = fs.getConf();
        switch (this.getConflictResolutionMode(context, fsConf)) {
            case FAIL: {
                break;
            }
            case APPEND: {
                break;
            }
            case REPLACE: {
                if (!fs.delete(outputPath, true)) break;
                LOG.info("{}: removed output path to be replaced: {}", (Object)this.getRole(), (Object)outputPath);
                break;
            }
            default: {
                throw new IOException(this.getRole() + ": unknown conflict resolution mode: " + (Object)((Object)this.getConflictResolutionMode(context, fsConf)));
            }
        }
    }
}

