/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.csi.client;

import csi.v0.Csi;
import java.io.IOException;
import java.net.SocketAddress;
import org.apache.hadoop.yarn.csi.client.CsiClient;
import org.apache.hadoop.yarn.csi.client.CsiGrpcClient;
import org.apache.hadoop.yarn.csi.utils.GrpcHelper;

public class CsiClientImpl
implements CsiClient {
    private final SocketAddress address;

    public CsiClientImpl(String address) {
        this.address = GrpcHelper.getSocketAddress(address);
    }

    @Override
    public Csi.GetPluginInfoResponse getPluginInfo() throws IOException {
        try (CsiGrpcClient client = CsiGrpcClient.newBuilder().setDomainSocketAddress(this.address).build();){
            Csi.GetPluginInfoRequest request = Csi.GetPluginInfoRequest.getDefaultInstance();
            Csi.GetPluginInfoResponse getPluginInfoResponse = client.createIdentityBlockingStub().getPluginInfo(request);
            return getPluginInfoResponse;
        }
    }

    @Override
    public Csi.ValidateVolumeCapabilitiesResponse validateVolumeCapabilities(Csi.ValidateVolumeCapabilitiesRequest request) throws IOException {
        try (CsiGrpcClient client = CsiGrpcClient.newBuilder().setDomainSocketAddress(this.address).build();){
            Csi.ValidateVolumeCapabilitiesResponse validateVolumeCapabilitiesResponse = client.createControllerBlockingStub().validateVolumeCapabilities(request);
            return validateVolumeCapabilitiesResponse;
        }
    }

    @Override
    public Csi.NodePublishVolumeResponse nodePublishVolume(Csi.NodePublishVolumeRequest request) throws IOException {
        try (CsiGrpcClient client = CsiGrpcClient.newBuilder().setDomainSocketAddress(this.address).build();){
            Csi.NodePublishVolumeResponse nodePublishVolumeResponse = client.createNodeBlockingStub().nodePublishVolume(request);
            return nodePublishVolumeResponse;
        }
    }

    @Override
    public Csi.NodeUnpublishVolumeResponse nodeUnpublishVolume(Csi.NodeUnpublishVolumeRequest request) throws IOException {
        try (CsiGrpcClient client = CsiGrpcClient.newBuilder().setDomainSocketAddress(this.address).build();){
            Csi.NodeUnpublishVolumeResponse nodeUnpublishVolumeResponse = client.createNodeBlockingStub().nodeUnpublishVolume(request);
            return nodeUnpublishVolumeResponse;
        }
    }
}

