/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamespaceUtil {
    public static final Logger LOG = LoggerFactory.getLogger(NamespaceUtil.class);

    private NamespaceUtil() {
    }

    public static Boolean isNamespaceEnabled(AbfsClient abfsClient, TracingContext tracingContext) throws AzureBlobFileSystemException {
        Boolean isNamespaceEnabled;
        try {
            LOG.debug("Get root ACL status");
            abfsClient.getAclStatus("/", tracingContext);
            isNamespaceEnabled = true;
        }
        catch (AbfsRestOperationException ex) {
            if (400 != ex.getStatusCode()) {
                throw ex;
            }
            isNamespaceEnabled = false;
        }
        catch (AzureBlobFileSystemException ex) {
            throw ex;
        }
        return isNamespaceEnabled;
    }
}

