/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.GenericConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineSchemaUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationOperation;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityTable;

public enum FlowActivityColumnPrefix implements ColumnPrefix<FlowActivityTable>
{
    RUN_ID(FlowActivityColumnFamily.INFO, "r", null);

    private final ColumnFamily<FlowActivityTable> columnFamily;
    private final ValueConverter valueConverter = GenericConverter.getInstance();
    private final String columnPrefix;
    private final byte[] columnPrefixBytes;
    private final AggregationOperation aggOp;

    private FlowActivityColumnPrefix(ColumnFamily<FlowActivityTable> columnFamily, String columnPrefix, AggregationOperation aggOp) {
        this(columnFamily, columnPrefix, aggOp, false);
    }

    private FlowActivityColumnPrefix(ColumnFamily<FlowActivityTable> columnFamily, String columnPrefix, AggregationOperation aggOp, boolean compoundColQual) {
        this.columnFamily = columnFamily;
        this.columnPrefix = columnPrefix;
        this.columnPrefixBytes = (byte[])(columnPrefix == null ? null : Bytes.toBytes((String)Separator.SPACE.encode(columnPrefix)));
        this.aggOp = aggOp;
    }

    public String getColumnPrefix() {
        return this.columnPrefix;
    }

    @Override
    public byte[] getColumnPrefixBytes(byte[] qualifierPrefix) {
        return ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifierPrefix);
    }

    @Override
    public byte[] getColumnPrefixBytes(String qualifierPrefix) {
        return ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifierPrefix);
    }

    public byte[] getColumnPrefixBytes() {
        return (byte[])this.columnPrefixBytes.clone();
    }

    @Override
    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    @Override
    public byte[] getColumnPrefixInBytes() {
        return this.columnPrefixBytes != null ? (byte[])this.columnPrefixBytes.clone() : null;
    }

    @Override
    public ValueConverter getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public Attribute[] getCombinedAttrsWithAggr(Attribute ... attributes) {
        return HBaseTimelineSchemaUtils.combineAttributes(attributes, this.aggOp);
    }

    @Override
    public boolean supplementCellTimeStamp() {
        return false;
    }

    public AggregationOperation getAttribute() {
        return this.aggOp;
    }
}

