/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.monitor.probe;

import java.io.Serializable;
import java.util.Date;
import org.apache.hadoop.yarn.service.monitor.probe.LogEntryBuilder;
import org.apache.hadoop.yarn.service.monitor.probe.Probe;

public final class ProbeStatus
implements Serializable {
    private static final long serialVersionUID = 165468L;
    private long timestamp;
    private String timestampText;
    private boolean success;
    private boolean realOutcome;
    private String message;
    private Throwable thrown;
    private transient Probe originator;

    public ProbeStatus() {
    }

    public ProbeStatus(long timestamp, String message, Throwable thrown) {
        this.success = false;
        this.message = message;
        this.thrown = thrown;
        this.setTimestamp(timestamp);
    }

    public ProbeStatus(long timestamp, String message) {
        this.success = true;
        this.setTimestamp(timestamp);
        this.message = message;
        this.thrown = null;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        this.timestampText = new Date(timestamp).toString();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
        this.realOutcome = success;
    }

    public String getTimestampText() {
        return this.timestampText;
    }

    public boolean getRealOutcome() {
        return this.realOutcome;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public void setThrown(Throwable thrown) {
        this.thrown = thrown;
    }

    public Probe getOriginator() {
        return this.originator;
    }

    public void succeed(Probe probe) {
        this.finish(probe, true, probe.getName(), null);
    }

    public void fail(Probe probe, Throwable thrown) {
        this.finish(probe, false, "Failure in " + probe, thrown);
    }

    public void finish(Probe probe, boolean succeeded, String text, Throwable thrown) {
        this.setTimestamp(System.currentTimeMillis());
        this.setSuccess(succeeded);
        this.originator = probe;
        this.message = text;
        this.thrown = thrown;
    }

    public String toString() {
        LogEntryBuilder builder = new LogEntryBuilder("Probe Status");
        builder.elt("time", this.timestampText).elt("outcome", this.success ? "success" : "failure");
        if (this.success != this.realOutcome) {
            builder.elt("originaloutcome", this.realOutcome ? "success" : "failure");
        }
        builder.elt("message", this.message);
        if (this.thrown != null) {
            builder.elt("exception", this.thrown);
        }
        return builder.toString();
    }

    public void markAsSuccessful() {
        this.success = true;
    }
}

