/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.api.records;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@ApiModel(description="Set of configuration properties that can be injected into the service components via envs, files and custom pluggable helper docker containers. Files of several standard formats like xml, properties, json, yaml and templates will be supported.")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Configuration
implements Serializable {
    private static final long serialVersionUID = -4330788704981074466L;
    private Map<String, String> properties = new HashMap<String, String>();
    private Map<String, String> env = new HashMap<String, String>();
    private List<ConfigFile> files = new ArrayList<ConfigFile>();

    public Configuration properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    @ApiModelProperty(example="null", value="A blob of key-value pairs of common service properties.")
    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Configuration env(Map<String, String> env) {
        this.env = env;
        return this;
    }

    @ApiModelProperty(example="null", value="A blob of key-value pairs which will be appended to the default system properties and handed off to the service at start time. All placeholder references to properties will be substituted before injection.")
    @JsonProperty(value="env")
    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public Configuration files(List<ConfigFile> files) {
        this.files = files;
        return this;
    }

    @ApiModelProperty(example="null", value="Array of list of files that needs to be created and made available as volumes in the service component containers.")
    @JsonProperty(value="files")
    public List<ConfigFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<ConfigFile> files) {
        this.files = files;
    }

    public long getPropertyLong(String name, long defaultValue) {
        String value = this.getProperty(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public int getPropertyInt(String name, int defaultValue) {
        String value = this.getProperty(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public boolean getPropertyBool(String name, boolean defaultValue) {
        String value = this.getProperty(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.get(name.trim());
    }

    public String getEnv(String name) {
        return this.env.get(name.trim());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration configuration = (Configuration)o;
        return Objects.equals(this.properties, configuration.properties) && Objects.equals(this.env, configuration.env) && Objects.equals(this.files, configuration.files);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.env, this.files);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Configuration {\n").append("    properties: ").append(this.toIndentedString(this.properties)).append("\n").append("    env: ").append(this.toIndentedString(this.env)).append("\n").append("    files: ").append(this.toIndentedString(this.files)).append("\n").append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public synchronized void mergeFrom(Configuration that) {
        ServiceUtils.mergeMapsIgnoreDuplicateKeys(this.properties, that.getProperties());
        ServiceUtils.mergeMapsIgnoreDuplicateKeys(this.env, that.getEnv());
        HashMap<String, ConfigFile> thatMap = new HashMap<String, ConfigFile>();
        for (ConfigFile file : that.getFiles()) {
            thatMap.put(file.getDestFile(), file.copy());
        }
        for (ConfigFile thisFile : this.files) {
            if (!thatMap.containsKey(thisFile.getDestFile())) continue;
            ConfigFile thatFile = (ConfigFile)thatMap.get(thisFile.getDestFile());
            ServiceUtils.mergeMapsIgnoreDuplicateKeys(thisFile.getProperties(), thatFile.getProperties());
            thatMap.remove(thisFile.getDestFile());
        }
        for (ConfigFile thatFile : thatMap.values()) {
            this.files.add(thatFile.copy());
        }
    }
}

