/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.reader;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnRWHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.StringKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityRowKeyPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.TimelineEntityReader;
import org.apache.hadoop.yarn.webapp.BadRequestException;

class GenericEntityReader
extends TimelineEntityReader {
    private static final EntityTableRW ENTITY_TABLE = new EntityTableRW();
    private final KeyConverter<String> stringKeyConverter = new StringKeyConverter();

    GenericEntityReader(TimelineReaderContext ctxt, TimelineEntityFilters entityFilters, TimelineDataToRetrieve toRetrieve) {
        super(ctxt, entityFilters, toRetrieve);
    }

    GenericEntityReader(TimelineReaderContext ctxt, TimelineDataToRetrieve toRetrieve) {
        super(ctxt, toRetrieve);
    }

    @Override
    protected BaseTableRW<?> getTable() {
        return ENTITY_TABLE;
    }

    @Override
    protected FilterList constructFilterListBasedOnFilters() throws IOException {
        TimelineFilterList infoFilters;
        TimelineFilterList configFilters;
        TimelineFilterList metricFilters;
        FilterList listBasedOnFilters = new FilterList(new Filter[0]);
        TimelineEntityFilters filters = this.getFilters();
        long createdTimeBegin = filters.getCreatedTimeBegin();
        long createdTimeEnd = filters.getCreatedTimeEnd();
        if (createdTimeBegin != 0L || createdTimeEnd != Long.MAX_VALUE) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createSingleColValueFiltersByRange(EntityColumn.CREATED_TIME, createdTimeBegin, createdTimeEnd));
        }
        if ((metricFilters = filters.getMetricFilters()) != null && !metricFilters.getFilterList().isEmpty()) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList(EntityColumnPrefix.METRIC, metricFilters));
        }
        if ((configFilters = filters.getConfigFilters()) != null && !configFilters.getFilterList().isEmpty()) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList(EntityColumnPrefix.CONFIG, configFilters));
        }
        if ((infoFilters = filters.getInfoFilters()) != null && !infoFilters.getFilterList().isEmpty()) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList(EntityColumnPrefix.INFO, infoFilters));
        }
        return listBasedOnFilters;
    }

    protected boolean fetchPartialEventCols(TimelineFilterList eventFilters, EnumSet<TimelineReader.Field> fieldsToRetrieve) {
        return eventFilters != null && !eventFilters.getFilterList().isEmpty() && !this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS);
    }

    protected boolean fetchPartialRelatesToCols(TimelineFilterList relatesTo, EnumSet<TimelineReader.Field> fieldsToRetrieve) {
        return relatesTo != null && !relatesTo.getFilterList().isEmpty() && !this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO);
    }

    private boolean fetchPartialIsRelatedToCols(TimelineFilterList isRelatedTo, EnumSet<TimelineReader.Field> fieldsToRetrieve) {
        return isRelatedTo != null && !isRelatedTo.getFilterList().isEmpty() && !this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO);
    }

    protected boolean fetchPartialColsFromInfoFamily() {
        EnumSet fieldsToRetrieve = this.getDataToRetrieve().getFieldsToRetrieve();
        TimelineEntityFilters filters = this.getFilters();
        return this.fetchPartialEventCols(filters.getEventFilters(), fieldsToRetrieve) || this.fetchPartialRelatesToCols(filters.getRelatesTo(), fieldsToRetrieve) || this.fetchPartialIsRelatedToCols(filters.getIsRelatedTo(), fieldsToRetrieve);
    }

    protected boolean needCreateFilterListBasedOnFields() {
        boolean flag;
        TimelineDataToRetrieve dataToRetrieve = this.getDataToRetrieve();
        boolean bl = flag = !dataToRetrieve.getFieldsToRetrieve().contains(TimelineReader.Field.ALL) || dataToRetrieve.getConfsToRetrieve() != null && !dataToRetrieve.getConfsToRetrieve().getFilterList().isEmpty() || dataToRetrieve.getMetricsToRetrieve() != null && !dataToRetrieve.getMetricsToRetrieve().getFilterList().isEmpty();
        if (!flag && !this.isSingleEntityRead()) {
            TimelineEntityFilters filters = this.getFilters();
            flag = filters.getEventFilters() != null && !filters.getEventFilters().getFilterList().isEmpty() || filters.getIsRelatedTo() != null && !filters.getIsRelatedTo().getFilterList().isEmpty() || filters.getRelatesTo() != null && !filters.getRelatesTo().getFilterList().isEmpty();
        }
        return flag;
    }

    protected void updateFixedColumns(FilterList list) {
        for (EntityColumn column : EntityColumn.values()) {
            list.addFilter((Filter)new QualifierFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(column.getColumnQualifierBytes())));
        }
    }

    private FilterList createFilterListForColsOfInfoFamily() throws IOException {
        FilterList infoFamilyColsFilter = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        this.updateFixedColumns(infoFamilyColsFilter);
        EnumSet fieldsToRetrieve = this.getDataToRetrieve().getFieldsToRetrieve();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.INFO)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.EQUAL, EntityColumnPrefix.INFO));
        }
        TimelineFilterList relatesTo = this.getFilters().getRelatesTo();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.EQUAL, EntityColumnPrefix.RELATES_TO));
        } else if (relatesTo != null && !relatesTo.getFilterList().isEmpty()) {
            Set<String> relatesToCols = TimelineFilterUtils.fetchColumnsFromFilterList(relatesTo);
            infoFamilyColsFilter.addFilter((Filter)this.createFiltersFromColumnQualifiers(EntityColumnPrefix.RELATES_TO, relatesToCols));
        }
        TimelineFilterList isRelatedTo = this.getFilters().getIsRelatedTo();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.EQUAL, EntityColumnPrefix.IS_RELATED_TO));
        } else if (isRelatedTo != null && !isRelatedTo.getFilterList().isEmpty()) {
            Set<String> isRelatedToCols = TimelineFilterUtils.fetchColumnsFromFilterList(isRelatedTo);
            infoFamilyColsFilter.addFilter((Filter)this.createFiltersFromColumnQualifiers(EntityColumnPrefix.IS_RELATED_TO, isRelatedToCols));
        }
        TimelineFilterList eventFilters = this.getFilters().getEventFilters();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.EQUAL, EntityColumnPrefix.EVENT));
        } else if (eventFilters != null && !eventFilters.getFilterList().isEmpty()) {
            Set<String> eventCols = TimelineFilterUtils.fetchColumnsFromFilterList(eventFilters);
            infoFamilyColsFilter.addFilter((Filter)this.createFiltersFromColumnQualifiers(EntityColumnPrefix.EVENT, eventCols));
        }
        return infoFamilyColsFilter;
    }

    private void excludeFieldsFromInfoColFamily(FilterList infoColFamilyList) {
        EnumSet fieldsToRetrieve = this.getDataToRetrieve().getFieldsToRetrieve();
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, EntityColumnPrefix.EVENT));
        }
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.INFO)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, EntityColumnPrefix.INFO));
        }
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, EntityColumnPrefix.IS_RELATED_TO));
        }
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, EntityColumnPrefix.RELATES_TO));
        }
    }

    private void updateFilterForConfsAndMetricsToRetrieve(FilterList listBasedOnFields, Set<String> cfsInFields) throws IOException {
        TimelineDataToRetrieve dataToRetrieve = this.getDataToRetrieve();
        if (dataToRetrieve.getFieldsToRetrieve().contains(TimelineReader.Field.CONFIGS)) {
            listBasedOnFields.addFilter(TimelineFilterUtils.createFilterForConfsOrMetricsToRetrieve(dataToRetrieve.getConfsToRetrieve(), EntityColumnFamily.CONFIGS, EntityColumnPrefix.CONFIG));
            cfsInFields.add(Bytes.toString((byte[])EntityColumnFamily.CONFIGS.getBytes()));
        }
        if (dataToRetrieve.getFieldsToRetrieve().contains(TimelineReader.Field.METRICS)) {
            listBasedOnFields.addFilter(TimelineFilterUtils.createFilterForConfsOrMetricsToRetrieve(dataToRetrieve.getMetricsToRetrieve(), EntityColumnFamily.METRICS, EntityColumnPrefix.METRIC));
            cfsInFields.add(Bytes.toString((byte[])EntityColumnFamily.METRICS.getBytes()));
        }
    }

    @Override
    protected FilterList constructFilterListBasedOnFields(Set<String> cfsInFields) throws IOException {
        if (!this.needCreateFilterListBasedOnFields()) {
            return null;
        }
        FilterList listBasedOnFields = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        FilterList infoColFamilyList = new FilterList(new Filter[0]);
        FamilyFilter infoColumnFamily = new FamilyFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(EntityColumnFamily.INFO.getBytes()));
        infoColFamilyList.addFilter((Filter)infoColumnFamily);
        if (!this.isSingleEntityRead() && this.fetchPartialColsFromInfoFamily()) {
            infoColFamilyList.addFilter((Filter)this.createFilterListForColsOfInfoFamily());
        } else {
            this.excludeFieldsFromInfoColFamily(infoColFamilyList);
        }
        listBasedOnFields.addFilter((Filter)infoColFamilyList);
        cfsInFields.add(Bytes.toString((byte[])EntityColumnFamily.INFO.getBytes()));
        this.updateFilterForConfsAndMetricsToRetrieve(listBasedOnFields, cfsInFields);
        return listBasedOnFields;
    }

    @Override
    protected void validateParams() {
        if (this.getContext() == null) {
            throw new NullPointerException("context shouldn't be null");
        }
        if (this.getDataToRetrieve() == null) {
            throw new NullPointerException("data to retrieve shouldn't be null");
        }
        if (this.getContext().getClusterId() == null) {
            throw new NullPointerException("clusterId shouldn't be null");
        }
        if (this.getContext().getAppId() == null) {
            throw new NullPointerException("appId shouldn't be null");
        }
        if (this.getContext().getEntityType() == null) {
            throw new NullPointerException("entityType shouldn't be null");
        }
        if (this.isSingleEntityRead() && this.getContext().getEntityId() == null) {
            throw new NullPointerException("entityId shouldn't be null");
        }
    }

    @Override
    protected void augmentParams(Configuration hbaseConf, Connection conn) throws IOException {
        this.defaultAugmentParams(hbaseConf, conn);
        this.getDataToRetrieve().addFieldsBasedOnConfsAndMetricsToRetrieve();
        if (!this.isSingleEntityRead()) {
            this.createFiltersIfNull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Result getResult(Configuration hbaseConf, Connection conn, FilterList filterList) throws IOException {
        TimelineReaderContext context = this.getContext();
        Result result = null;
        if (context.getEntityIdPrefix() != null) {
            byte[] rowKey = new EntityRowKey(context.getClusterId(), context.getUserId(), context.getFlowName(), context.getFlowRunId(), context.getAppId(), context.getEntityType(), context.getEntityIdPrefix(), context.getEntityId()).getRowKey();
            Get get = new Get(rowKey);
            this.setMetricsTimeRange((Query)get);
            get.setMaxVersions(this.getDataToRetrieve().getMetricsLimit().intValue());
            if (filterList != null && !filterList.getFilters().isEmpty()) {
                get.setFilter((Filter)filterList);
            }
            result = this.getTable().getResult(hbaseConf, conn, get);
        } else {
            FilterList filter = new FilterList(FilterList.Operator.MUST_PASS_ALL);
            if (filterList != null && !filterList.getFilters().isEmpty()) {
                filter.addFilter((Filter)filterList);
            }
            FilterList newFilter = new FilterList(new Filter[0]);
            newFilter.addFilter(TimelineFilterUtils.createHBaseSingleColValueFilter(EntityColumn.ID, context.getEntityId(), CompareFilter.CompareOp.EQUAL));
            newFilter.addFilter((Filter)new PageFilter(1L));
            filter.addFilter((Filter)newFilter);
            try (ResultScanner results = this.getResults(hbaseConf, conn, filter);){
                Iterator iterator = results.iterator();
                if (iterator.hasNext()) {
                    result = (Result)iterator.next();
                }
            }
        }
        return result;
    }

    private void setMetricsTimeRange(Query query) {
        HBaseTimelineStorageUtils.setMetricsTimeRange(query, EntityColumnFamily.METRICS.getBytes(), this.getDataToRetrieve().getMetricsTimeBegin(), this.getDataToRetrieve().getMetricsTimeEnd());
    }

    @Override
    protected ResultScanner getResults(Configuration hbaseConf, Connection conn, FilterList filterList) throws IOException {
        Scan scan = new Scan();
        TimelineReaderContext context = this.getContext();
        EntityRowKeyPrefix entityRowKeyPrefix = null;
        if (this.getFilters() == null || this.getFilters().getFromId() == null) {
            entityRowKeyPrefix = new EntityRowKeyPrefix(context.getClusterId(), context.getUserId(), context.getFlowName(), context.getFlowRunId(), context.getAppId(), context.getEntityType(), null, null);
            scan.setRowPrefixFilter(entityRowKeyPrefix.getRowKeyPrefix());
        } else {
            EntityRowKey entityRowKey = null;
            try {
                entityRowKey = EntityRowKey.parseRowKeyFromString((String)this.getFilters().getFromId());
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Invalid filter fromid is provided.");
            }
            if (!context.getClusterId().equals(entityRowKey.getClusterId())) {
                throw new BadRequestException("fromid doesn't belong to clusterId=" + context.getClusterId());
            }
            scan.withStartRow(entityRowKey.getRowKey());
            entityRowKeyPrefix = new EntityRowKeyPrefix(context.getClusterId(), context.getUserId(), context.getFlowName(), context.getFlowRunId(), context.getAppId(), context.getEntityType(), null, null);
            scan.withStopRow(HBaseTimelineStorageUtils.calculateTheClosestNextRowKeyForPrefix(entityRowKeyPrefix.getRowKeyPrefix()));
            filterList.addFilter((Filter)new PageFilter(this.getFilters().getLimit()));
        }
        this.setMetricsTimeRange((Query)scan);
        scan.setMaxVersions(this.getDataToRetrieve().getMetricsLimit().intValue());
        if (filterList != null && !filterList.getFilters().isEmpty()) {
            scan.setFilter((Filter)filterList);
        }
        return this.getTable().getResultScanner(hbaseConf, conn, scan);
    }

    @Override
    protected TimelineEntity parseEntity(Result result) throws IOException {
        boolean checkEvents;
        boolean checkRelatesTo;
        boolean checkIsRelatedTo;
        if (result == null || result.isEmpty()) {
            return null;
        }
        TimelineEntity entity = new TimelineEntity();
        EntityRowKey parseRowKey = EntityRowKey.parseRowKey((byte[])result.getRow());
        entity.setType(parseRowKey.getEntityType());
        entity.setId(parseRowKey.getEntityId());
        entity.setIdPrefix(parseRowKey.getEntityIdPrefix().longValue());
        TimelineEntityFilters filters = this.getFilters();
        Long createdTime = (Long)ColumnRWHelper.readResult(result, EntityColumn.CREATED_TIME);
        entity.setCreatedTime(createdTime);
        EnumSet fieldsToRetrieve = this.getDataToRetrieve().getFieldsToRetrieve();
        boolean bl = checkIsRelatedTo = !this.isSingleEntityRead() && filters.getIsRelatedTo() != null && filters.getIsRelatedTo().getFilterList().size() > 0;
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO) || checkIsRelatedTo) {
            this.readRelationship(entity, result, EntityColumnPrefix.IS_RELATED_TO, true);
            if (checkIsRelatedTo && !TimelineStorageUtils.matchIsRelatedTo((TimelineEntity)entity, (TimelineFilterList)filters.getIsRelatedTo())) {
                return null;
            }
            if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO)) {
                entity.getIsRelatedToEntities().clear();
            }
        }
        boolean bl2 = checkRelatesTo = !this.isSingleEntityRead() && filters.getRelatesTo() != null && filters.getRelatesTo().getFilterList().size() > 0;
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO) || checkRelatesTo) {
            this.readRelationship(entity, result, EntityColumnPrefix.RELATES_TO, false);
            if (checkRelatesTo && !TimelineStorageUtils.matchRelatesTo((TimelineEntity)entity, (TimelineFilterList)filters.getRelatesTo())) {
                return null;
            }
            if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO)) {
                entity.getRelatesToEntities().clear();
            }
        }
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.INFO)) {
            this.readKeyValuePairs(entity, result, (ColumnPrefix)EntityColumnPrefix.INFO, false);
        }
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.CONFIGS)) {
            this.readKeyValuePairs(entity, result, (ColumnPrefix)EntityColumnPrefix.CONFIG, true);
        }
        boolean bl3 = checkEvents = !this.isSingleEntityRead() && filters.getEventFilters() != null && filters.getEventFilters().getFilterList().size() > 0;
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS) || checkEvents) {
            GenericEntityReader.readEvents(entity, result, EntityColumnPrefix.EVENT);
            if (checkEvents && !TimelineStorageUtils.matchEventFilters((TimelineEntity)entity, (TimelineFilterList)filters.getEventFilters())) {
                return null;
            }
            if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS)) {
                entity.getEvents().clear();
            }
        }
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.METRICS)) {
            this.readMetrics(entity, result, (ColumnPrefix<?>)EntityColumnPrefix.METRIC);
        }
        entity.getInfo().put("FROM_ID", parseRowKey.getRowKeyAsString());
        return entity;
    }

    protected <T extends BaseTable<T>> void readKeyValuePairs(TimelineEntity entity, Result result, ColumnPrefix<T> prefix, boolean isConfig) throws IOException {
        Map<String, Object> columns = ColumnRWHelper.readResults(result, prefix, this.stringKeyConverter);
        if (isConfig) {
            for (Map.Entry<String, Object> column : columns.entrySet()) {
                entity.addConfig(column.getKey(), column.getValue().toString());
            }
        } else {
            entity.addInfo(columns);
        }
    }
}

