/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.server.webapp.WebPageUtils;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class HsNavBlock
extends HtmlBlock {
    final App app;
    private Configuration conf;

    @Inject
    HsNavBlock(App app, Configuration conf) {
        this.app = app;
        this.conf = conf;
    }

    protected void render(HtmlBlock.Block html) {
        Hamlet.UL tools;
        Hamlet.DIV nav = (Hamlet.DIV)((Hamlet.UL)((Hamlet.UL)html.div("#nav").h3("Application").ul().li().a(this.url(new String[]{"about"}), "About").__()).li().a(this.url(new String[]{"app"}), "Jobs").__()).__();
        if (this.app.getJob() != null) {
            String jobid = MRApps.toString((JobId)this.app.getJob().getID());
            ((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)nav.h3("Job").ul().li().a(this.url(new String[]{"job", jobid}), "Overview").__()).li().a(this.url(new String[]{"jobcounters", jobid}), "Counters").__()).li().a(this.url(new String[]{"conf", jobid}), "Configuration").__()).li().a(this.url(new String[]{"tasks", jobid, "m"}), "Map tasks").__()).li().a(this.url(new String[]{"tasks", jobid, "r"}), "Reduce tasks").__()).__();
            if (this.app.getTask() != null) {
                String taskid = MRApps.toString((TaskId)this.app.getTask().getID());
                ((Hamlet.UL)((Hamlet.UL)nav.h3("Task").ul().li().a(this.url(new String[]{"task", taskid}), "Task Overview").__()).li().a(this.url(new String[]{"taskcounters", taskid}), "Counters").__()).__();
            }
        }
        if ((tools = WebPageUtils.appendToolSection((Hamlet.DIV)nav, (Configuration)this.conf)) != null) {
            ((Hamlet.DIV)tools.__()).__();
        }
    }
}

