/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.rx.internal.Configs;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.pipeline.PipelineConfiguratorComposite;
import io.reactivex.netty.pipeline.ssl.SSLEngineFactory;
import io.reactivex.netty.pipeline.ssl.SslCompletionHandler;
import io.reactivex.netty.protocol.http.HttpObjectAggregationConfigurator;
import io.reactivex.netty.protocol.http.client.CompositeHttpClientBuilder;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientPipelineConfigurator;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    private static final String NETWORK_LOG_CATEGORY = "com.microsoft.azure.cosmosdb.netty-network";
    private final Configs configs;
    private Integer maxPoolSize;
    private Integer maxIdleConnectionTimeoutInMillis;
    private Integer requestTimeoutInMillis;
    private InetSocketAddress proxy;

    public HttpClientFactory(Configs configs) {
        this.configs = configs;
    }

    public HttpClientFactory withPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public HttpClientFactory withHttpProxy(InetSocketAddress proxy) {
        this.proxy = proxy;
        return this;
    }

    public HttpClientFactory withMaxIdleConnectionTimeoutInMillis(int maxIdleConnectionTimeoutInMillis) {
        this.maxIdleConnectionTimeoutInMillis = maxIdleConnectionTimeoutInMillis;
        return this;
    }

    public HttpClientFactory withRequestTimeoutInMillis(int requestTimeoutInMillis) {
        this.requestTimeoutInMillis = requestTimeoutInMillis;
        return this;
    }

    public CompositeHttpClientBuilder<ByteBuf, ByteBuf> toHttpClientBuilder() {
        if (this.configs == null) {
            throw new IllegalArgumentException("configs is null");
        }
        DefaultSSLEngineFactory defaultSSLEngineFactory = new DefaultSSLEngineFactory();
        CompositeHttpClientBuilder builder = new CompositeHttpClientBuilder();
        if (this.maxPoolSize != null) {
            builder = builder.withMaxConnections(this.maxPoolSize.intValue());
        }
        if (this.maxIdleConnectionTimeoutInMillis != null) {
            builder = (CompositeHttpClientBuilder)builder.withIdleConnectionsTimeoutMillis((long)this.maxIdleConnectionTimeoutInMillis.intValue());
        }
        builder = (CompositeHttpClientBuilder)((CompositeHttpClientBuilder)((CompositeHttpClientBuilder)builder.pipelineConfigurator(pipeline -> {
            LoggingHandler loggingHandler = HttpClientFactory.getLoggingHandler();
            if (loggingHandler != null) {
                pipeline.addFirst("logging-handler", (ChannelHandler)loggingHandler);
            }
            if (this.proxy != null) {
                pipeline.addFirst("http-proxy-handler", (ChannelHandler)new HttpProxyHandler((SocketAddress)this.proxy));
            }
        })).appendPipelineConfigurator(new SslPipelineConfiguratorUsedWithProxy(defaultSSLEngineFactory))).appendPipelineConfigurator(HttpClientFactory.createClientPipelineConfigurator(this.configs));
        if (this.requestTimeoutInMillis != null) {
            HttpClient.HttpClientConfig.Builder clientConfigBuilder = new HttpClient.HttpClientConfig.Builder();
            clientConfigBuilder.readTimeout(this.requestTimeoutInMillis.intValue(), TimeUnit.MILLISECONDS);
            return (CompositeHttpClientBuilder)builder.config(clientConfigBuilder.build());
        }
        return builder;
    }

    private static PipelineConfigurator createClientPipelineConfigurator(Configs config) {
        PipelineConfiguratorComposite clientPipelineConfigurator = new PipelineConfiguratorComposite(new PipelineConfigurator[]{new HttpClientPipelineConfigurator(config.getMaxHttpInitialLineLength(), config.getMaxHttpHeaderSize(), config.getMaxHttpChunkSize(), true), new HttpObjectAggregationConfigurator(config.getMaxHttpBodyLength())});
        return clientPipelineConfigurator;
    }

    private static LoggingHandler getLoggingHandler() {
        if (LoggerFactory.getLogger((String)NETWORK_LOG_CATEGORY).isTraceEnabled()) {
            return new LoggingHandler(NETWORK_LOG_CATEGORY, LogLevel.TRACE);
        }
        return null;
    }

    class SslPipelineConfiguratorUsedWithProxy<I, O>
    implements PipelineConfigurator<I, O> {
        private final SSLEngineFactory sslEngineFactory;

        private SslPipelineConfiguratorUsedWithProxy(SSLEngineFactory sslEngineFactory) {
            this.sslEngineFactory = sslEngineFactory;
        }

        public void configureNewPipeline(ChannelPipeline pipeline) {
            SslHandler sslHandler = new SslHandler(this.sslEngineFactory.createSSLEngine(pipeline.channel().alloc()));
            if (HttpClientFactory.this.proxy != null) {
                pipeline.addAfter("http-proxy-handler", "ssl-handler", (ChannelHandler)sslHandler);
            } else {
                pipeline.addFirst("ssl-handler", (ChannelHandler)sslHandler);
            }
            pipeline.addAfter("ssl-handler", "ssl-completion-handler", (ChannelHandler)new SslCompletionHandler(sslHandler.handshakeFuture()));
        }
    }

    class DefaultSSLEngineFactory
    implements SSLEngineFactory {
        private final SslContext sslContext;

        private DefaultSSLEngineFactory() {
            this.sslContext = HttpClientFactory.this.configs.getSslContext();
        }

        public SSLEngine createSSLEngine(ByteBufAllocator allocator) {
            return this.sslContext.newEngine(allocator);
        }
    }
}

