/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.microsoft.azure.cosmosdb.CompositePath;
import com.microsoft.azure.cosmosdb.ExcludedPath;
import com.microsoft.azure.cosmosdb.IncludedPath;
import com.microsoft.azure.cosmosdb.Index;
import com.microsoft.azure.cosmosdb.IndexingMode;
import com.microsoft.azure.cosmosdb.JsonSerializable;
import com.microsoft.azure.cosmosdb.SpatialSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.text.WordUtils;

public final class IndexingPolicy
extends JsonSerializable {
    private static final String DEFAULT_PATH = "/*";
    private Collection<IncludedPath> includedPaths;
    private Collection<ExcludedPath> excludedPaths;
    private Collection<ArrayList<CompositePath>> compositeIndexes;
    private Collection<SpatialSpec> spatialIndexes;

    public IndexingPolicy() {
        this.setAutomatic(true);
        this.setIndexingMode(IndexingMode.Consistent);
    }

    public IndexingPolicy(Index[] defaultIndexOverrides) {
        this();
        if (defaultIndexOverrides == null) {
            throw new IllegalArgumentException("defaultIndexOverrides is null.");
        }
        IncludedPath includedPath = new IncludedPath();
        includedPath.setPath(DEFAULT_PATH);
        includedPath.setIndexes(new ArrayList<Index>(Arrays.asList(defaultIndexOverrides)));
        this.getIncludedPaths().add(includedPath);
    }

    public IndexingPolicy(String jsonString) {
        super(jsonString);
    }

    public Boolean getAutomatic() {
        return super.getBoolean("automatic");
    }

    public void setAutomatic(boolean automatic) {
        super.set("automatic", automatic);
    }

    public IndexingMode getIndexingMode() {
        IndexingMode result = IndexingMode.Lazy;
        try {
            result = IndexingMode.valueOf(WordUtils.capitalize((String)super.getString("indexingMode")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("Invalid indexingMode value {}.", (Object)super.getString("indexingMode"));
        }
        return result;
    }

    public void setIndexingMode(IndexingMode indexingMode) {
        super.set("indexingMode", indexingMode.name());
    }

    public Collection<IncludedPath> getIncludedPaths() {
        if (this.includedPaths == null) {
            this.includedPaths = super.getCollection("includedPaths", IncludedPath.class);
            if (this.includedPaths == null) {
                this.includedPaths = new ArrayList<IncludedPath>();
            }
        }
        return this.includedPaths;
    }

    public void setIncludedPaths(Collection<IncludedPath> includedPaths) {
        this.includedPaths = includedPaths;
    }

    public Collection<ExcludedPath> getExcludedPaths() {
        if (this.excludedPaths == null) {
            this.excludedPaths = super.getCollection("excludedPaths", ExcludedPath.class);
            if (this.excludedPaths == null) {
                this.excludedPaths = new ArrayList<ExcludedPath>();
            }
        }
        return this.excludedPaths;
    }

    public void setExcludedPaths(Collection<ExcludedPath> excludedPaths) {
        this.excludedPaths = excludedPaths;
    }

    public Collection<ArrayList<CompositePath>> getCompositeIndexes() {
        if (this.compositeIndexes == null) {
            this.compositeIndexes = new ArrayList<ArrayList<CompositePath>>();
            ArrayNode compositeIndexes = (ArrayNode)super.get("compositeIndexes");
            for (int i = 0; i < compositeIndexes.size(); ++i) {
                ArrayNode compositeIndex = (ArrayNode)compositeIndexes.get(i);
                ArrayList<CompositePath> compositePaths = new ArrayList<CompositePath>();
                for (int j = 0; j < compositeIndex.size(); ++j) {
                    CompositePath candidateCompositePath = new CompositePath(compositeIndex.get(j).toString());
                    compositePaths.add(candidateCompositePath);
                }
                this.compositeIndexes.add(compositePaths);
            }
        }
        return this.compositeIndexes;
    }

    public void setCompositeIndexes(Collection<ArrayList<CompositePath>> compositeIndexes) {
        this.compositeIndexes = compositeIndexes;
        super.set("compositeIndexes", this.compositeIndexes);
    }

    public Collection<SpatialSpec> getSpatialIndexes() {
        if (this.spatialIndexes == null) {
            this.spatialIndexes = super.getCollection("spatialIndexes", SpatialSpec.class);
            if (this.spatialIndexes == null) {
                this.spatialIndexes = new ArrayList<SpatialSpec>();
            }
        }
        return this.spatialIndexes;
    }

    public void setSpatialIndexes(Collection<SpatialSpec> spatialIndexes) {
        this.spatialIndexes = spatialIndexes;
        super.set("spatialIndexes", this.spatialIndexes);
    }

    @Override
    void populatePropertyBag() {
        if (this.getIndexingMode() != IndexingMode.None && this.getIncludedPaths().size() == 0 && this.getExcludedPaths().size() == 0) {
            IncludedPath includedPath = new IncludedPath();
            includedPath.setPath(DEFAULT_PATH);
            this.getIncludedPaths().add(includedPath);
        }
        if (this.includedPaths != null) {
            for (IncludedPath includedPath : this.includedPaths) {
                includedPath.populatePropertyBag();
            }
            super.set("includedPaths", this.includedPaths);
        }
        if (this.excludedPaths != null) {
            for (ExcludedPath excludedPath : this.excludedPaths) {
                excludedPath.populatePropertyBag();
            }
            super.set("excludedPaths", this.excludedPaths);
        }
    }
}

