/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.router.MountTableRefresherService;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaManager;
import org.apache.hadoop.hdfs.server.federation.store.CachedRecordStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUnavailableException;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class MountTableStore
extends CachedRecordStore<MountTable>
implements MountTableManager {
    private static final Logger LOG = LoggerFactory.getLogger(MountTableStore.class);
    private MountTableRefresherService refreshService;
    private RouterQuotaManager quotaManager;

    public MountTableStore(StateStoreDriver driver) {
        super(MountTable.class, driver);
    }

    public void setRefreshService(MountTableRefresherService refreshService) {
        this.refreshService = refreshService;
    }

    public void setQuotaManager(RouterQuotaManager quotaManager) {
        this.quotaManager = quotaManager;
    }

    public RouterQuotaManager getQuotaManager() {
        return this.quotaManager;
    }

    protected void updateCacheAllRouters() {
        if (this.refreshService != null) {
            try {
                this.refreshService.refresh();
            }
            catch (StateStoreUnavailableException e) {
                LOG.error("Cannot refresh mount table: state store not available", (Throwable)e);
            }
        }
    }
}

