/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.metrics.NamenodeBeanMetrics;
import org.apache.hadoop.hdfs.server.federation.metrics.RBFMetrics;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClientMetrics;
import org.apache.hadoop.hdfs.server.federation.router.RouterMetrics;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.service.AbstractService;

public class RouterMetricsService
extends AbstractService {
    private final Router router;
    private RouterMetrics routerMetrics;
    private RouterClientMetrics routerClientMetrics;
    private RBFMetrics rbfMetrics;
    private NamenodeBeanMetrics nnMetrics;

    public RouterMetricsService(Router router) {
        super(RouterMetricsService.class.getName());
        this.router = router;
    }

    protected void serviceInit(Configuration configuration) throws Exception {
        this.routerMetrics = RouterMetrics.create(configuration);
        this.routerClientMetrics = RouterClientMetrics.create(configuration);
    }

    protected void serviceStart() throws Exception {
        this.nnMetrics = new NamenodeBeanMetrics(this.router);
        this.rbfMetrics = new RBFMetrics(this.router);
    }

    protected void serviceStop() throws Exception {
        if (this.rbfMetrics != null) {
            this.rbfMetrics.close();
        }
        if (this.nnMetrics != null) {
            this.nnMetrics.close();
        }
        if (this.routerMetrics != null) {
            this.routerMetrics.shutdown();
        }
        if (this.routerClientMetrics != null) {
            this.routerClientMetrics.shutdown();
        }
    }

    public RouterMetrics getRouterMetrics() {
        return this.routerMetrics;
    }

    public RouterClientMetrics getRouterClientMetrics() {
        return this.routerClientMetrics;
    }

    public RBFMetrics getRBFMetrics() {
        return this.rbfMetrics;
    }

    public NamenodeBeanMetrics getNamenodeMetrics() {
        return this.nnMetrics;
    }

    public JvmMetrics getJvmMetrics() {
        if (this.routerMetrics == null) {
            return null;
        }
        return this.routerMetrics.getJvmMetrics();
    }
}

