/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.concurrent.atomic.LongAccumulator;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.hdfs.server.federation.router.RouterStateIdContext;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;

public class PoolAlignmentContext
implements AlignmentContext {
    private LongAccumulator sharedGlobalStateId;
    private LongAccumulator poolLocalStateId;

    PoolAlignmentContext(RouterStateIdContext routerStateIdContext, String namespaceId) {
        this.sharedGlobalStateId = routerStateIdContext.getNamespaceStateId(namespaceId);
        this.poolLocalStateId = new LongAccumulator(Math::max, Long.MIN_VALUE);
    }

    public void updateResponseState(RpcHeaderProtos.RpcResponseHeaderProto.Builder header) {
    }

    public void receiveResponseState(RpcHeaderProtos.RpcResponseHeaderProto header) {
        this.sharedGlobalStateId.accumulate(header.getStateId());
    }

    public void updateRequestState(RpcHeaderProtos.RpcRequestHeaderProto.Builder header) {
        header.setStateId(this.poolLocalStateId.get());
    }

    public long receiveRequestState(RpcHeaderProtos.RpcRequestHeaderProto header, long threshold) throws IOException {
        return 0L;
    }

    public long getLastSeenStateId() {
        return this.sharedGlobalStateId.get();
    }

    public boolean isCoordinatedCall(String protocolName, String method) {
        throw new UnsupportedOperationException("Client should not be checking uncoordinated call");
    }

    public void advanceClientStateId(Long clientStateId) {
        this.poolLocalStateId.accumulate(clientStateId);
    }

    @VisibleForTesting
    public long getPoolLocalStateId() {
        return this.poolLocalStateId.get();
    }
}

