/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.fairness;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.fairness.AbstractRouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticRouterRpcFairnessPolicyController
extends AbstractRouterRpcFairnessPolicyController {
    private static final Logger LOG = LoggerFactory.getLogger(StaticRouterRpcFairnessPolicyController.class);
    public static final String ERROR_MSG = "Configured handlers dfs.federation.router.handler.count= %d is less than the minimum required handlers %d";

    public StaticRouterRpcFairnessPolicyController(Configuration conf) {
        this.init(conf);
    }

    @Override
    public void init(Configuration conf) throws IllegalArgumentException {
        super.init(conf);
        int handlerCount = conf.getInt("dfs.federation.router.handler.count", 10);
        LOG.info("Handlers available for fairness assignment {} ", (Object)handlerCount);
        Set<String> allConfiguredNS = FederationUtil.getAllConfiguredNS(conf);
        HashSet<String> unassignedNS = new HashSet<String>();
        allConfiguredNS.add("concurrent");
        this.validateHandlersCount(conf, handlerCount, allConfiguredNS);
        for (String string : allConfiguredNS) {
            int n = conf.getInt("dfs.federation.router.fairness.handler.count." + string, 0);
            LOG.info("Dedicated handlers {} for ns {} ", (Object)n, (Object)string);
            if (n > 0) {
                handlerCount -= n;
                this.insertNameServiceWithPermits(string, n);
                StaticRouterRpcFairnessPolicyController.logAssignment(string, n);
                continue;
            }
            unassignedNS.add(string);
        }
        if (!unassignedNS.isEmpty()) {
            LOG.info("Unassigned ns {}", unassignedNS);
            int handlersPerNS = handlerCount / unassignedNS.size();
            LOG.info("Handlers available per ns {}", (Object)handlersPerNS);
            for (String string : unassignedNS) {
                this.insertNameServiceWithPermits(string, handlersPerNS);
                StaticRouterRpcFairnessPolicyController.logAssignment(string, handlersPerNS);
            }
        }
        int leftOverHandlers = unassignedNS.isEmpty() ? handlerCount : handlerCount % unassignedNS.size();
        int n = this.getAvailablePermits("concurrent");
        if (leftOverHandlers > 0) {
            LOG.info("Assigned extra {} handlers to commons pool", (Object)leftOverHandlers);
            this.insertNameServiceWithPermits("concurrent", n + leftOverHandlers);
        }
        LOG.info("Final permit allocation for concurrent ns: {}", (Object)this.getAvailablePermits("concurrent"));
    }

    private static void logAssignment(String nsId, int count) {
        LOG.info("Assigned {} handlers to nsId {} ", (Object)count, (Object)nsId);
    }

    private void validateHandlersCount(Configuration conf, int handlerCount, Set<String> allConfiguredNS) {
        int totalDedicatedHandlers = 0;
        for (String nsId : allConfiguredNS) {
            int dedicatedHandlers = conf.getInt("dfs.federation.router.fairness.handler.count." + nsId, 0);
            if (dedicatedHandlers > 0) {
                totalDedicatedHandlers += dedicatedHandlers;
                continue;
            }
            ++totalDedicatedHandlers;
        }
        if (totalDedicatedHandlers > handlerCount) {
            String msg = String.format(ERROR_MSG, handlerCount, totalDedicatedHandlers);
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
    }
}

