/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AWSCredentialProviderList
implements AWSCredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AWSCredentialProviderList.class);
    public static final String NO_AWS_CREDENTIAL_PROVIDERS = "No AWS Credential Providers";
    private final List<AWSCredentialsProvider> providers = new ArrayList<AWSCredentialsProvider>(1);
    private boolean reuseLastProvider = true;
    private AWSCredentialsProvider lastProvider;

    public AWSCredentialProviderList() {
    }

    public AWSCredentialProviderList(Collection<AWSCredentialsProvider> providers) {
        this.providers.addAll(providers);
    }

    public void add(AWSCredentialsProvider p) {
        this.providers.add(p);
    }

    public void setReuseLastProvider(boolean reuseLastProvider) {
        this.reuseLastProvider = reuseLastProvider;
    }

    public boolean isReuseLastProvider() {
        return this.reuseLastProvider;
    }

    public void refresh() {
        for (AWSCredentialsProvider provider : this.providers) {
            provider.refresh();
        }
    }

    public AWSCredentials getCredentials() {
        this.checkNotEmpty();
        if (this.reuseLastProvider && this.lastProvider != null) {
            return this.lastProvider.getCredentials();
        }
        AmazonClientException lastException = null;
        for (AWSCredentialsProvider provider : this.providers) {
            try {
                AWSCredentials credentials = provider.getCredentials();
                if ((credentials.getAWSAccessKeyId() == null || credentials.getAWSSecretKey() == null) && !(credentials instanceof AnonymousAWSCredentials)) continue;
                this.lastProvider = provider;
                LOG.debug("Using credentials from {}", (Object)provider);
                return credentials;
            }
            catch (AmazonClientException e) {
                lastException = e;
                LOG.debug("No credentials provided by {}: {}", new Object[]{provider, e.toString(), e});
            }
        }
        String message = "No AWS Credentials provided by " + this.listProviderNames();
        if (lastException != null) {
            message = message + ": " + (Object)((Object)lastException);
        }
        throw new AmazonClientException(message, (Throwable)lastException);
    }

    @VisibleForTesting
    List<AWSCredentialsProvider> getProviders() {
        return this.providers;
    }

    public void checkNotEmpty() {
        if (this.providers.isEmpty()) {
            throw new AmazonClientException(NO_AWS_CREDENTIAL_PROVIDERS);
        }
    }

    public String listProviderNames() {
        StringBuilder sb = new StringBuilder(this.providers.size() * 32);
        for (AWSCredentialsProvider provider : this.providers) {
            sb.append(provider.getClass().getSimpleName());
            sb.append(' ');
        }
        return sb.toString();
    }

    public String toString() {
        return "AWSCredentialProviderList: " + StringUtils.join(this.providers, (String)" ");
    }
}

