/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.util.regex.Pattern;

public final class UriUtils {
    private static final String ABFS_URI_REGEX = "[^.]+\\.dfs\\.(preprod\\.){0,1}core\\.windows\\.net";
    private static final Pattern ABFS_URI_PATTERN = Pattern.compile("[^.]+\\.dfs\\.(preprod\\.){0,1}core\\.windows\\.net");

    public static boolean containsAbfsUrl(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        return ABFS_URI_PATTERN.matcher(string).matches();
    }

    public static String extractAccountNameFromHostName(String hostName) {
        if (hostName == null || hostName.isEmpty()) {
            return null;
        }
        if (!UriUtils.containsAbfsUrl(hostName)) {
            return null;
        }
        String[] splitByDot = hostName.split("\\.");
        if (splitByDot.length == 0) {
            return null;
        }
        return splitByDot[0];
    }

    public static String generateUniqueTestPath() {
        String testUniqueForkId = System.getProperty("test.unique.fork.id");
        return testUniqueForkId == null ? "/test" : "/" + testUniqueForkId + "/test";
    }

    private UriUtils() {
    }
}

