/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose;

import org.apache.hadoop.shaded.com.nimbusds.jose.IllegalHeaderException;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSHeader;
import org.apache.hadoop.shaded.com.nimbusds.jose.UnprotectedHeader;

class HeaderValidation {
    static void ensureDisjoint(JWSHeader jwsHeader, UnprotectedHeader unprotectedHeader) throws IllegalHeaderException {
        if (jwsHeader == null || unprotectedHeader == null) {
            return;
        }
        for (String unprotectedParamName : unprotectedHeader.getIncludedParams()) {
            if (!jwsHeader.getIncludedParams().contains(unprotectedParamName)) continue;
            throw new IllegalHeaderException("The parameters in the JWS protected header and the unprotected header must be disjoint");
        }
    }

    private HeaderValidation() {
    }
}

