/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAccumulator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.ClientGSIContext;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.MembershipNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.router.RouterStateIdContext;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.RouterObserverReadProxyProvider;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class TestObserverWithRouter {
    private static final int NUM_NAMESERVICES = 2;
    private static final String SKIP_BEFORE_EACH_CLUSTER_STARTUP = "SkipBeforeEachClusterStartup";
    private MiniRouterDFSCluster cluster;
    private MiniRouterDFSCluster.RouterContext routerContext;
    private FileSystem fileSystem;

    @BeforeEach
    void init(TestInfo info) throws Exception {
        if (info.getTags().contains(SKIP_BEFORE_EACH_CLUSTER_STARTUP)) {
            return;
        }
        this.startUpCluster(2, null);
    }

    @AfterEach
    public void teardown() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        this.routerContext = null;
        if (this.fileSystem != null) {
            this.fileSystem.close();
            this.fileSystem = null;
        }
    }

    public void startUpCluster(int numberOfObserver, Configuration confOverrides) throws Exception {
        int numberOfNamenode = 2 + numberOfObserver;
        Configuration conf = new Configuration(false);
        conf.setBoolean("dfs.federation.router.observer.read.default", true);
        conf.setBoolean("dfs.ha.tail-edits.in-progress", true);
        conf.set("dfs.ha.tail-edits.period", "0ms");
        conf.setBoolean("dfs.namenode.state.context.enabled", true);
        if (confOverrides != null) {
            confOverrides.iterator().forEachRemaining(entry -> conf.set((String)entry.getKey(), (String)entry.getValue()));
        }
        this.cluster = new MiniRouterDFSCluster(true, 2, numberOfNamenode);
        this.cluster.addNamenodeOverrides(conf);
        this.cluster.startCluster();
        if (this.cluster.isHighAvailability()) {
            for (String ns : this.cluster.getNameservices()) {
                this.cluster.switchToActive(ns, FederationTestUtils.NAMENODES[0]);
                this.cluster.switchToStandby(ns, FederationTestUtils.NAMENODES[1]);
                for (int i = 2; i < numberOfNamenode; ++i) {
                    this.cluster.switchToObserver(ns, FederationTestUtils.NAMENODES[i]);
                }
            }
        }
        Configuration routerConf = new RouterConfigBuilder().metrics().rpc().build();
        this.cluster.addRouterOverrides(conf);
        this.cluster.addRouterOverrides(routerConf);
        this.cluster.startRouters();
        this.cluster.registerNamenodes();
        this.cluster.waitNamenodeRegistration();
        this.cluster.installMockLocations();
        this.cluster.waitActiveNamespaces();
        this.routerContext = this.cluster.getRandomRouter();
    }

    private Configuration getConfToEnableObserverReads(ConfigSetting configSetting) {
        Configuration conf = new Configuration();
        switch (configSetting) {
            case USE_NAMENODE_PROXY_FLAG: {
                conf.setBoolean("dfs.client.rbf.observer.read.enable", true);
                break;
            }
            case USE_ROUTER_OBSERVER_READ_PROXY_PROVIDER: {
                conf.set("dfs.client.failover.proxy.provider." + this.routerContext.getRouter().getRpcServerAddress().getHostName(), RouterObserverReadProxyProvider.class.getName());
                break;
            }
            default: {
                Assertions.fail((String)("Unknown config setting: " + (Object)((Object)configSetting)));
            }
        }
        return conf;
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    public void testObserverRead(ConfigSetting configSetting) throws Exception {
        this.fileSystem = this.routerContext.getFileSystem(this.getConfToEnableObserverReads(configSetting));
        this.internalTestObserverRead();
    }

    @Test
    public void testReadWithoutObserverClientConfigurations() throws Exception {
        this.fileSystem = this.routerContext.getFileSystem();
        Assert.assertThrows(AssertionError.class, this::internalTestObserverRead);
    }

    public void internalTestObserverRead() throws Exception {
        List namenodes = this.routerContext.getRouter().getNamenodeResolver().getNamenodesForNameserviceId(this.cluster.getNameservices().get(0), true);
        Assert.assertEquals((String)"First namenode should be observer", (Object)((FederationNamenodeContext)namenodes.get(0)).getState(), (Object)FederationNamenodeServiceState.OBSERVER);
        Path path = new Path("/testFile");
        this.fileSystem.create(path).close();
        this.fileSystem.open(path).close();
        long rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        Assert.assertEquals((String)"Two calls should be sent to active", (long)2L, (long)rpcCountForActive);
        long rpcCountForObserver = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getObserverProxyOps();
        Assert.assertEquals((String)"One call should be sent to observer", (long)1L, (long)rpcCountForObserver);
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    @Tag(value="SkipBeforeEachClusterStartup")
    public void testObserverReadWithoutFederatedStatePropagation(ConfigSetting configSetting) throws Exception {
        Configuration confOverrides = new Configuration(false);
        confOverrides.setInt("dfs.federation.router.observer.federated.state.propagation.maxsize", 0);
        this.startUpCluster(2, confOverrides);
        this.fileSystem = this.routerContext.getFileSystem(this.getConfToEnableObserverReads(configSetting));
        List namenodes = this.routerContext.getRouter().getNamenodeResolver().getNamenodesForNameserviceId(this.cluster.getNameservices().get(0), true);
        Assert.assertEquals((String)"First namenode should be observer", (Object)((FederationNamenodeContext)namenodes.get(0)).getState(), (Object)FederationNamenodeServiceState.OBSERVER);
        Path path = new Path("/testFile");
        this.fileSystem.create(path).close();
        this.fileSystem.open(path).close();
        long rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        Assert.assertEquals((String)"Three calls should be sent to active", (long)3L, (long)rpcCountForActive);
        long rpcCountForObserver = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getObserverProxyOps();
        Assert.assertEquals((String)"No call should be sent to observer", (long)0L, (long)rpcCountForObserver);
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    @Tag(value="SkipBeforeEachClusterStartup")
    public void testDisablingObserverReadUsingNameserviceOverride(ConfigSetting configSetting) throws Exception {
        Configuration confOverrides = new Configuration(false);
        confOverrides.set("dfs.federation.router.observer.read.overrides", "ns0");
        this.startUpCluster(2, confOverrides);
        this.fileSystem = this.routerContext.getFileSystem(this.getConfToEnableObserverReads(configSetting));
        Path path = new Path("/testFile");
        this.fileSystem.create(path).close();
        this.fileSystem.open(path).close();
        long rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        Assert.assertEquals((String)"Three calls should be sent to active", (long)3L, (long)rpcCountForActive);
        long rpcCountForObserver = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getObserverProxyOps();
        Assert.assertEquals((String)"Zero calls should be sent to observer", (long)0L, (long)rpcCountForObserver);
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    public void testReadWhenObserverIsDown(ConfigSetting configSetting) throws Exception {
        this.fileSystem = this.routerContext.getFileSystem(this.getConfToEnableObserverReads(configSetting));
        Path path = new Path("/testFile1");
        this.fileSystem.create(path).close();
        int nnIndex = this.stopObserver(1);
        Assert.assertNotEquals((String)"No observer found", (long)3L, (long)nnIndex);
        nnIndex = this.stopObserver(1);
        Assert.assertNotEquals((String)"No observer found", (long)4L, (long)nnIndex);
        this.fileSystem.open(path).close();
        long rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        Assert.assertEquals((String)"Three calls should be sent to active", (long)3L, (long)rpcCountForActive);
        long rpcCountForObserver = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getObserverProxyOps();
        Assert.assertEquals((String)"No call should send to observer", (long)0L, (long)rpcCountForObserver);
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    public void testMultipleObserver(ConfigSetting configSetting) throws Exception {
        this.fileSystem = this.routerContext.getFileSystem(this.getConfToEnableObserverReads(configSetting));
        Path path = new Path("/testFile1");
        this.fileSystem.create(path).close();
        this.stopObserver(1);
        this.fileSystem.open(path).close();
        long rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        long expectedActiveRpc = 2L;
        long expectedObserverRpc = 1L;
        Assert.assertEquals((String)"Two calls should be sent to active", (long)expectedActiveRpc, (long)rpcCountForActive);
        long rpcCountForObserver = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getObserverProxyOps();
        Assert.assertEquals((String)"Read should be success with another observer", (long)expectedObserverRpc, (long)rpcCountForObserver);
        this.stopObserver(1);
        this.fileSystem.open(path).close();
        rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        Assert.assertEquals((String)"One call should be sent to active", (long)(++expectedActiveRpc), (long)rpcCountForActive);
        rpcCountForObserver = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getObserverProxyOps();
        Assert.assertEquals((String)"No call should send to observer", (long)(expectedObserverRpc += 0L), (long)rpcCountForObserver);
    }

    private int stopObserver(int num) {
        int nnIndex;
        for (nnIndex = 0; nnIndex < this.cluster.getNamenodes().size(); ++nnIndex) {
            NameNode nameNode = this.cluster.getCluster().getNameNode(nnIndex);
            if (nameNode == null || !nameNode.isObserverState()) continue;
            this.cluster.getCluster().shutdownNameNode(nnIndex);
            if (--num == 0) break;
        }
        return nnIndex;
    }

    @Test
    @Tag(value="SkipBeforeEachClusterStartup")
    public void testMultipleObserverRouter() throws Exception {
        StateStoreDFSCluster innerCluster = new StateStoreDFSCluster(true, 4, 4, TimeUnit.SECONDS.toMillis(5L), TimeUnit.SECONDS.toMillis(5L));
        Configuration routerConf = new RouterConfigBuilder().stateStore().admin().rpc().enableLocalHeartbeat(true).heartbeat().build();
        StringBuilder sb = new StringBuilder();
        String ns0 = innerCluster.getNameservices().get(0);
        MiniRouterDFSCluster.NamenodeContext context = innerCluster.getNamenodes(ns0).get(1);
        routerConf.set("dfs.nameservice.id", ns0);
        routerConf.set("dfs.ha.namenode.id", context.getNamenodeId());
        String ns1 = innerCluster.getNameservices().get(1);
        for (MiniRouterDFSCluster.NamenodeContext ctx : innerCluster.getNamenodes(ns1)) {
            String suffix = ctx.getConfSuffix();
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(suffix);
        }
        routerConf.set("dfs.federation.router.monitor.namenode", sb.toString());
        routerConf.setBoolean("dfs.federation.router.observer.read.default", true);
        routerConf.setBoolean("dfs.ha.tail-edits.in-progress", true);
        routerConf.set("dfs.ha.tail-edits.period", "0ms");
        innerCluster.addNamenodeOverrides(routerConf);
        innerCluster.addRouterOverrides(routerConf);
        innerCluster.startCluster();
        if (innerCluster.isHighAvailability()) {
            for (String ns : innerCluster.getNameservices()) {
                innerCluster.switchToActive(ns, FederationTestUtils.NAMENODES[0]);
                innerCluster.switchToStandby(ns, FederationTestUtils.NAMENODES[1]);
                for (int i = 2; i < 4; ++i) {
                    innerCluster.switchToObserver(ns, FederationTestUtils.NAMENODES[i]);
                }
            }
        }
        innerCluster.startRouters();
        innerCluster.waitClusterUp();
        this.routerContext = innerCluster.getRandomRouter();
        MembershipNamenodeResolver resolver = (MembershipNamenodeResolver)this.routerContext.getRouter().getNamenodeResolver();
        resolver.loadCache(true);
        List namespaceInfo0 = resolver.getNamenodesForNameserviceId(ns0, true);
        List namespaceInfo1 = resolver.getNamenodesForNameserviceId(ns1, true);
        Assert.assertEquals((Object)((FederationNamenodeContext)namespaceInfo0.get(0)).getState(), (Object)FederationNamenodeServiceState.OBSERVER);
        Assert.assertEquals((Object)((FederationNamenodeContext)namespaceInfo0.get(1)).getState(), (Object)FederationNamenodeServiceState.OBSERVER);
        Assert.assertNotEquals((Object)((FederationNamenodeContext)namespaceInfo0.get(0)).getNamenodeId(), (Object)((FederationNamenodeContext)namespaceInfo0.get(1)).getNamenodeId());
        Assert.assertEquals((Object)((FederationNamenodeContext)namespaceInfo1.get(0)).getState(), (Object)FederationNamenodeServiceState.OBSERVER);
        innerCluster.shutdown();
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    public void testUnavailableObserverNN(ConfigSetting configSetting) throws Exception {
        this.fileSystem = this.routerContext.getFileSystem(this.getConfToEnableObserverReads(configSetting));
        this.stopObserver(2);
        Path path = new Path("/testFile");
        this.fileSystem.create(path).close();
        this.fileSystem.open(path).close();
        long rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        Assert.assertEquals((String)"Three calls should be send to active", (long)3L, (long)rpcCountForActive);
        boolean hasUnavailable = false;
        for (String ns : this.cluster.getNameservices()) {
            List nns = this.routerContext.getRouter().getNamenodeResolver().getNamenodesForNameserviceId(ns, false);
            for (FederationNamenodeContext nn : nns) {
                if (FederationNamenodeServiceState.UNAVAILABLE != nn.getState()) continue;
                hasUnavailable = true;
            }
        }
        Assert.assertTrue((String)"There must be unavailable namenodes", (boolean)hasUnavailable);
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    public void testRouterMsync(ConfigSetting configSetting) throws Exception {
        this.fileSystem = this.routerContext.getFileSystem(this.getConfToEnableObserverReads(configSetting));
        Path path = new Path("/testFile");
        this.fileSystem.create(path).close();
        long rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        Assert.assertEquals((String)"Two calls should be sent to active", (long)2L, (long)rpcCountForActive);
        this.fileSystem.msync();
        rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        Assert.assertEquals((String)"Four calls should be sent to active", (long)4L, (long)rpcCountForActive);
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    public void testSingleRead(ConfigSetting configSetting) throws Exception {
        this.fileSystem = this.routerContext.getFileSystem(this.getConfToEnableObserverReads(configSetting));
        List namenodes = this.routerContext.getRouter().getNamenodeResolver().getNamenodesForNameserviceId(this.cluster.getNameservices().get(0), true);
        Assert.assertEquals((String)"First namenode should be observer", (Object)((FederationNamenodeContext)namenodes.get(0)).getState(), (Object)FederationNamenodeServiceState.OBSERVER);
        Path path = new Path("/");
        this.fileSystem.listFiles(path, false);
        this.fileSystem.close();
        long rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        Assert.assertEquals((String)"Only one call should be sent to active", (long)1L, (long)rpcCountForActive);
        long rpcCountForObserver = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getObserverProxyOps();
        Assert.assertEquals((String)"No calls should be sent to observer", (long)0L, (long)rpcCountForObserver);
    }

    @Test
    public void testSingleReadUsingObserverReadProxyProvider() throws Exception {
        this.fileSystem = this.routerContext.getFileSystemWithObserverReadProxyProvider();
        List namenodes = this.routerContext.getRouter().getNamenodeResolver().getNamenodesForNameserviceId(this.cluster.getNameservices().get(0), true);
        Assert.assertEquals((String)"First namenode should be observer", (Object)((FederationNamenodeContext)namenodes.get(0)).getState(), (Object)FederationNamenodeServiceState.OBSERVER);
        Path path = new Path("/");
        this.fileSystem.listFiles(path, false);
        this.fileSystem.close();
        long rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        Assert.assertEquals((String)"Two calls should be sent to active", (long)2L, (long)rpcCountForActive);
        long rpcCountForObserver = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getObserverProxyOps();
        Assert.assertEquals((String)"One call should be sent to observer", (long)1L, (long)rpcCountForObserver);
    }

    @Test
    @Tag(value="SkipBeforeEachClusterStartup")
    public void testClientReceiveResponseState() {
        ClientGSIContext clientGSIContext = new ClientGSIContext();
        HashMap<String, Long> mockMapping = new HashMap<String, Long>();
        mockMapping.put("ns0", 10L);
        HdfsProtos.RouterFederatedStateProto.Builder builder = HdfsProtos.RouterFederatedStateProto.newBuilder();
        mockMapping.forEach((arg_0, arg_1) -> ((HdfsProtos.RouterFederatedStateProto.Builder)builder).putNamespaceStateIds(arg_0, arg_1));
        RpcHeaderProtos.RpcResponseHeaderProto header = RpcHeaderProtos.RpcResponseHeaderProto.newBuilder().setCallId(1).setStatus(RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.SUCCESS).setRouterFederatedState(builder.build().toByteString()).build();
        clientGSIContext.receiveResponseState(header);
        HashMap<String, Long> mockLowerMapping = new HashMap<String, Long>();
        mockLowerMapping.put("ns0", 8L);
        builder = HdfsProtos.RouterFederatedStateProto.newBuilder();
        mockLowerMapping.forEach((arg_0, arg_1) -> ((HdfsProtos.RouterFederatedStateProto.Builder)builder).putNamespaceStateIds(arg_0, arg_1));
        header = RpcHeaderProtos.RpcResponseHeaderProto.newBuilder().setRouterFederatedState(builder.build().toByteString()).setCallId(2).setStatus(RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.SUCCESS).build();
        clientGSIContext.receiveResponseState(header);
        Map latestFederateState = ClientGSIContext.getRouterFederatedStateMap((ByteString)clientGSIContext.getRouterFederatedState());
        Assertions.assertEquals((int)1, (int)latestFederateState.size());
        Assertions.assertEquals((long)10L, (Long)((Long)latestFederateState.get("ns0")));
    }

    @Test
    @Tag(value="SkipBeforeEachClusterStartup")
    public void testRouterResponseHeaderState() {
        RouterStateIdContext routerStateIdContext = new RouterStateIdContext(new Configuration());
        ConcurrentHashMap namespaceIdMap = routerStateIdContext.getNamespaceIdMap();
        namespaceIdMap.put("ns0", new LongAccumulator(Math::max, 10L));
        namespaceIdMap.put("ns1", new LongAccumulator(Math::max, 100L));
        namespaceIdMap.put("ns2", new LongAccumulator(Math::max, Long.MIN_VALUE));
        HashMap<String, Long> mockMapping = new HashMap<String, Long>();
        mockMapping.put("ns0", 10L);
        mockMapping.put("ns2", 100L);
        mockMapping.put("ns3", Long.MIN_VALUE);
        HdfsProtos.RouterFederatedStateProto.Builder builder = HdfsProtos.RouterFederatedStateProto.newBuilder();
        mockMapping.forEach((arg_0, arg_1) -> ((HdfsProtos.RouterFederatedStateProto.Builder)builder).putNamespaceStateIds(arg_0, arg_1));
        RpcHeaderProtos.RpcResponseHeaderProto.Builder responseHeaderBuilder = RpcHeaderProtos.RpcResponseHeaderProto.newBuilder().setCallId(1).setStatus(RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.SUCCESS).setRouterFederatedState(builder.build().toByteString());
        routerStateIdContext.updateResponseState(responseHeaderBuilder);
        Map latestFederateState = RouterStateIdContext.getRouterFederatedStateMap((ByteString)responseHeaderBuilder.build().getRouterFederatedState());
        Assertions.assertEquals((int)2, (int)latestFederateState.size());
        Assertions.assertEquals((long)10L, (Long)((Long)latestFederateState.get("ns0")));
        Assertions.assertEquals((long)100L, (Long)((Long)latestFederateState.get("ns1")));
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    public void testStateIdProgressionInRouter(ConfigSetting configSetting) throws Exception {
        Path rootPath = new Path("/");
        this.fileSystem = this.routerContext.getFileSystem(this.getConfToEnableObserverReads(configSetting));
        RouterStateIdContext routerStateIdContext = this.routerContext.getRouterRpcServer().getRouterStateIdContext();
        for (int i = 0; i < 10; ++i) {
            this.fileSystem.create(new Path(rootPath, "file" + i)).close();
        }
        LongAccumulator namespaceStateId = routerStateIdContext.getNamespaceStateId("ns0");
        Assert.assertEquals((String)"Router's shared should have progressed.", (long)21L, (long)namespaceStateId.get());
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    @Tag(value="SkipBeforeEachClusterStartup")
    public void testSharedStateInRouterStateIdContext(ConfigSetting configSetting) throws Exception {
        Path rootPath = new Path("/");
        long cleanupPeriodMs = 1000L;
        Configuration conf = new Configuration(false);
        conf.setLong("dfs.federation.router.connection.pool.clean.ms", cleanupPeriodMs);
        conf.setLong("dfs.federation.router.connection.clean.ms", cleanupPeriodMs / 10L);
        this.startUpCluster(1, conf);
        this.fileSystem = this.routerContext.getFileSystem(this.getConfToEnableObserverReads(configSetting));
        RouterStateIdContext routerStateIdContext = this.routerContext.getRouterRpcServer().getRouterStateIdContext();
        this.fileSystem.listStatus(rootPath);
        this.fileSystem.listStatus(rootPath);
        LongAccumulator namespaceStateId1 = routerStateIdContext.getNamespaceStateId("ns0");
        Thread.sleep(cleanupPeriodMs * 2L);
        this.fileSystem.listStatus(rootPath);
        this.fileSystem.close();
        LongAccumulator namespaceStateId2 = routerStateIdContext.getNamespaceStateId("ns0");
        long rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        long rpcCountForObserver = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getObserverProxyOps();
        Assert.assertEquals((String)"One call should be sent to active", (long)1L, (long)rpcCountForActive);
        Assert.assertEquals((String)"Two calls should be sent to observer", (long)2L, (long)rpcCountForObserver);
        Assertions.assertSame((Object)namespaceStateId1, (Object)namespaceStateId2, (String)"The same object should be used in the shared RouterStateIdContext");
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    @Tag(value="SkipBeforeEachClusterStartup")
    public void testRouterStateIdContextCleanup(ConfigSetting configSetting) throws Exception {
        Path rootPath = new Path("/");
        long recordExpiry = TimeUnit.SECONDS.toMillis(1L);
        Configuration confOverride = new Configuration(false);
        confOverride.setLong("dfs.federation.router.store.membership.expiration", recordExpiry);
        this.startUpCluster(1, confOverride);
        this.fileSystem = this.routerContext.getFileSystem(this.getConfToEnableObserverReads(configSetting));
        RouterStateIdContext routerStateIdContext = this.routerContext.getRouterRpcServer().getRouterStateIdContext();
        this.fileSystem.listStatus(rootPath);
        List namespace1 = routerStateIdContext.getNamespaces();
        this.fileSystem.close();
        MockResolver mockResolver = (MockResolver)this.routerContext.getRouter().getNamenodeResolver();
        mockResolver.cleanRegistrations();
        mockResolver.setDisableRegistration(true);
        Thread.sleep(recordExpiry * 2L);
        List namespace2 = routerStateIdContext.getNamespaces();
        Assert.assertEquals((long)1L, (long)namespace1.size());
        Assert.assertEquals((Object)"ns0", namespace1.get(0));
        Assert.assertTrue((boolean)namespace2.isEmpty());
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    @Tag(value="SkipBeforeEachClusterStartup")
    public void testPeriodicStateRefreshUsingActiveNamenode(ConfigSetting configSetting) throws Exception {
        Path rootPath = new Path("/");
        Configuration confOverride = new Configuration(false);
        confOverride.set("dfs.federation.router.observer.state.id.refresh.period", "500ms");
        confOverride.set("dfs.ha.tail-edits.period", "3s");
        this.startUpCluster(1, confOverride);
        this.fileSystem = this.routerContext.getFileSystem(this.getConfToEnableObserverReads(configSetting));
        this.fileSystem.listStatus(rootPath);
        int initialLengthOfRootListing = this.fileSystem.listStatus(rootPath).length;
        DFSClient activeClient = this.cluster.getNamenodes("ns0").stream().filter(nnContext -> nnContext.getNamenode().isActiveState()).findFirst().orElseThrow(() -> new IllegalStateException("No active namenode.")).getClient();
        for (int i = 0; i < 10; ++i) {
            activeClient.mkdirs("/dir" + i, null, false);
        }
        activeClient.close();
        GenericTestUtils.waitFor(() -> !this.routerContext.getRouterRpcClient().isNamespaceStateIdFresh("ns0"), (long)100L, (long)10000L, (String)"Timeout: Namespace state was never considered stale.");
        FileStatus[] rootFolderAfterMkdir = this.fileSystem.listStatus(rootPath);
        Assert.assertEquals((String)"List-status should show newly created directories.", (long)(initialLengthOfRootListing + 10), (long)rootFolderAfterMkdir.length);
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    public void testAutoMsyncEqualsZero(ConfigSetting configSetting) throws Exception {
        Configuration clientConfiguration = this.getConfToEnableObserverReads(configSetting);
        clientConfiguration.setLong("dfs.client.failover.observer.auto-msync-period." + this.routerContext.getRouter().getRpcServerAddress().getHostName(), 0L);
        this.fileSystem = this.routerContext.getFileSystem(clientConfiguration);
        List namenodes = this.routerContext.getRouter().getNamenodeResolver().getNamenodesForNameserviceId(this.cluster.getNameservices().get(0), true);
        Assert.assertEquals((String)"First namenode should be observer", (Object)((FederationNamenodeContext)namenodes.get(0)).getState(), (Object)FederationNamenodeServiceState.OBSERVER);
        Path path = new Path("/");
        int numListings = 15;
        for (int i = 0; i < numListings; ++i) {
            this.fileSystem.listFiles(path, false);
        }
        this.fileSystem.close();
        long rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        long rpcCountForObserver = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getObserverProxyOps();
        switch (configSetting) {
            case USE_NAMENODE_PROXY_FLAG: {
                Assert.assertEquals((String)"Calls sent to the active", (long)1L, (long)rpcCountForActive);
                Assert.assertEquals((String)"Reads sent to observer", (long)(numListings - 1), (long)rpcCountForObserver);
                break;
            }
            case USE_ROUTER_OBSERVER_READ_PROXY_PROVIDER: {
                Assert.assertEquals((String)"Msyncs sent to the active namenodes", (long)(2 * numListings), (long)rpcCountForActive);
                Assert.assertEquals((String)"Reads sent to observer", (long)numListings, (long)rpcCountForObserver);
                break;
            }
            default: {
                Assertions.fail((String)("Unknown config setting: " + (Object)((Object)configSetting)));
            }
        }
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    public void testAutoMsyncNonZero(ConfigSetting configSetting) throws Exception {
        Configuration clientConfiguration = this.getConfToEnableObserverReads(configSetting);
        clientConfiguration.setLong("dfs.client.failover.observer.auto-msync-period." + this.routerContext.getRouter().getRpcServerAddress().getHostName(), 3000L);
        this.fileSystem = this.routerContext.getFileSystem(clientConfiguration);
        List namenodes = this.routerContext.getRouter().getNamenodeResolver().getNamenodesForNameserviceId(this.cluster.getNameservices().get(0), true);
        Assert.assertEquals((String)"First namenode should be observer", (Object)((FederationNamenodeContext)namenodes.get(0)).getState(), (Object)FederationNamenodeServiceState.OBSERVER);
        Path path = new Path("/");
        this.fileSystem.listFiles(path, false);
        this.fileSystem.listFiles(path, false);
        Thread.sleep(5000L);
        this.fileSystem.listFiles(path, false);
        this.fileSystem.close();
        long rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        long rpcCountForObserver = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getObserverProxyOps();
        switch (configSetting) {
            case USE_NAMENODE_PROXY_FLAG: {
                Assert.assertEquals((String)"Calls sent to the active", (long)1L, (long)rpcCountForActive);
                Assert.assertEquals((String)"Reads sent to observer", (long)2L, (long)rpcCountForObserver);
                break;
            }
            case USE_ROUTER_OBSERVER_READ_PROXY_PROVIDER: {
                Assert.assertEquals((String)"Msyncs sent to the active namenodes", (long)4L, (long)rpcCountForActive);
                Assert.assertEquals((String)"Reads sent to observer", (long)3L, (long)rpcCountForObserver);
                break;
            }
            default: {
                Assertions.fail((String)("Unknown config setting: " + (Object)((Object)configSetting)));
            }
        }
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    public void testThatWriteDoesntBypassNeedForMsync(ConfigSetting configSetting) throws Exception {
        Configuration clientConfiguration = this.getConfToEnableObserverReads(configSetting);
        clientConfiguration.setLong("dfs.client.failover.observer.auto-msync-period." + this.routerContext.getRouter().getRpcServerAddress().getHostName(), 3000L);
        this.fileSystem = this.routerContext.getFileSystem(clientConfiguration);
        List namenodes = this.routerContext.getRouter().getNamenodeResolver().getNamenodesForNameserviceId(this.cluster.getNameservices().get(0), true);
        Assert.assertEquals((String)"First namenode should be observer", (Object)((FederationNamenodeContext)namenodes.get(0)).getState(), (Object)FederationNamenodeServiceState.OBSERVER);
        Path path = new Path("/");
        this.fileSystem.listFiles(path, false);
        Thread.sleep(5000L);
        this.fileSystem.mkdirs(new Path(path, "mkdirLocation"));
        this.fileSystem.listFiles(path, false);
        this.fileSystem.close();
        long rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        long rpcCountForObserver = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getObserverProxyOps();
        switch (configSetting) {
            case USE_NAMENODE_PROXY_FLAG: {
                Assert.assertEquals((String)"Calls sent to the active namenodes", (long)2L, (long)rpcCountForActive);
                Assert.assertEquals((String)"Read sent to observer", (long)1L, (long)rpcCountForObserver);
                break;
            }
            case USE_ROUTER_OBSERVER_READ_PROXY_PROVIDER: {
                Assert.assertEquals((String)"Calls sent to the active namenodes", (long)5L, (long)rpcCountForActive);
                Assert.assertEquals((String)"Reads sent to observer", (long)2L, (long)rpcCountForObserver);
                break;
            }
            default: {
                Assertions.fail((String)("Unknown config setting: " + (Object)((Object)configSetting)));
            }
        }
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    @Tag(value="SkipBeforeEachClusterStartup")
    public void testMsyncOnlyToNamespaceWithObserver(ConfigSetting configSetting) throws Exception {
        Configuration confOverride = new Configuration(false);
        String namespaceWithObserverReadsDisabled = "ns0";
        confOverride.set("dfs.federation.router.observer.read.overrides", namespaceWithObserverReadsDisabled);
        this.startUpCluster(1, confOverride);
        this.fileSystem = this.routerContext.getFileSystem(this.getConfToEnableObserverReads(configSetting));
        this.fileSystem.msync();
        long rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        Assert.assertEquals((String)"Only one call to the namespace with an observer", (long)1L, (long)rpcCountForActive);
    }

    @EnumSource(value=ConfigSetting.class)
    @ParameterizedTest
    @Tag(value="SkipBeforeEachClusterStartup")
    public void testMsyncWithNoNamespacesEligibleForCRS(ConfigSetting configSetting) throws Exception {
        Configuration confOverride = new Configuration(false);
        confOverride.setBoolean("dfs.federation.router.observer.read.default", false);
        this.startUpCluster(1, confOverride);
        this.fileSystem = this.routerContext.getFileSystem(this.getConfToEnableObserverReads(configSetting));
        this.fileSystem.msync();
        long rpcCountForActive = this.routerContext.getRouter().getRpcServer().getRPCMetrics().getActiveProxyOps();
        Assert.assertEquals((String)"No calls to any namespace", (long)0L, (long)rpcCountForActive);
    }

    public static enum ConfigSetting {
        USE_NAMENODE_PROXY_FLAG,
        USE_ROUTER_OBSERVER_READ_PROXY_PROVIDER;

    }
}

