/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.microsoft.azure.cosmosdb.DataType;
import com.microsoft.azure.cosmosdb.Index;
import com.microsoft.azure.cosmosdb.IndexKind;
import org.apache.commons.text.WordUtils;

public final class HashIndex
extends Index {
    public HashIndex(DataType dataType) {
        super(IndexKind.Hash);
        this.setDataType(dataType);
    }

    public HashIndex(DataType dataType, int precision) {
        super(IndexKind.Hash);
        this.setDataType(dataType);
        this.setPrecision(precision);
    }

    public HashIndex(String jsonString) {
        super(jsonString, IndexKind.Hash);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    public DataType getDataType() {
        DataType result = null;
        try {
            result = DataType.valueOf(WordUtils.capitalize((String)super.getString("dataType")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("Invalid index dataType value {}.", (Object)super.getString("dataType"));
        }
        return result;
    }

    public void setDataType(DataType dataType) {
        super.set("dataType", dataType.name());
    }

    public int getPrecision() {
        return super.getInt("precision");
    }

    public void setPrecision(int precision) {
        super.set("precision", precision);
    }

    boolean hasPrecision() {
        return super.has("precision");
    }
}

